/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit5.execution;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.junit.gen5.api.extension.ExtensionContext;
import org.junit.gen5.api.extension.MethodInvocationContext;
import org.junit.gen5.api.extension.MethodParameterResolver;
import org.junit.gen5.api.extension.ParameterResolutionException;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.ReflectionUtils;
import org.junit.gen5.engine.junit5.extension.ExtensionRegistry;

@API(value=API.Usage.Internal)
public class MethodInvoker {
    private final ExtensionContext extensionContext;
    private final ExtensionRegistry extensionRegistry;

    public MethodInvoker(ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        this.extensionContext = extensionContext;
        this.extensionRegistry = extensionRegistry;
    }

    public void invoke(MethodInvocationContext methodInvocationContext) {
        ReflectionUtils.invokeMethod((Method)methodInvocationContext.getMethod(), (Object)methodInvocationContext.getInstance(), (Object[])this.resolveParameters(methodInvocationContext));
    }

    private Object[] resolveParameters(MethodInvocationContext methodInvocationContext) throws ParameterResolutionException {
        return Arrays.stream(methodInvocationContext.getMethod().getParameters()).map(param -> this.resolveParameter((Parameter)param, methodInvocationContext)).toArray(Object[]::new);
    }

    private Object resolveParameter(Parameter parameter, MethodInvocationContext methodInvocationContext) throws ParameterResolutionException {
        try {
            ArrayList matchingResolvers = new ArrayList();
            this.extensionRegistry.stream(MethodParameterResolver.class, ExtensionRegistry.ApplicationOrder.FORWARD).forEach(registeredExtensionPoint -> {
                if (((MethodParameterResolver)registeredExtensionPoint.getExtensionPoint()).supports(parameter, methodInvocationContext, this.extensionContext)) {
                    matchingResolvers.add(registeredExtensionPoint.getExtensionPoint());
                }
            });
            if (matchingResolvers.size() == 0) {
                throw new ParameterResolutionException(String.format("No MethodParameterResolver registered for parameter [%s] in method [%s].", parameter, methodInvocationContext.getMethod().toGenericString()));
            }
            if (matchingResolvers.size() > 1) {
                String resolverNames = matchingResolvers.stream().map(resolver -> resolver.getClass().getName()).collect(Collectors.joining(", "));
                throw new ParameterResolutionException(String.format("Discovered multiple competing MethodParameterResolvers for parameter [%s] in method [%s]: %s", parameter, methodInvocationContext.getMethod().toGenericString(), resolverNames));
            }
            return ((MethodParameterResolver)matchingResolvers.get(0)).resolve(parameter, methodInvocationContext, this.extensionContext);
        }
        catch (Throwable ex) {
            if (ex instanceof ParameterResolutionException) {
                throw (ParameterResolutionException)ex;
            }
            throw new ParameterResolutionException(String.format("Failed to resolve parameter [%s] in method [%s]", parameter, methodInvocationContext.getMethod().toGenericString()), ex);
        }
    }
}

