/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit5.extension;

import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.junit.gen5.api.Disabled;
import org.junit.gen5.api.extension.ConditionEvaluationResult;
import org.junit.gen5.api.extension.ContainerExecutionCondition;
import org.junit.gen5.api.extension.ContainerExtensionContext;
import org.junit.gen5.api.extension.TestExecutionCondition;
import org.junit.gen5.api.extension.TestExtensionContext;
import org.junit.gen5.commons.util.AnnotationUtils;
import org.junit.gen5.commons.util.StringUtils;

class DisabledCondition
implements ContainerExecutionCondition,
TestExecutionCondition {
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"@Disabled is not present");

    DisabledCondition() {
    }

    public ConditionEvaluationResult evaluate(ContainerExtensionContext context) {
        return this.evaluate(context.getElement());
    }

    public ConditionEvaluationResult evaluate(TestExtensionContext context) {
        return this.evaluate(context.getElement());
    }

    private ConditionEvaluationResult evaluate(AnnotatedElement element) {
        Optional disabled = AnnotationUtils.findAnnotation((AnnotatedElement)element, Disabled.class);
        if (disabled.isPresent()) {
            String reason = disabled.map(Disabled::value).filter(StringUtils::isNotBlank).orElseGet(() -> element + " is @Disabled");
            return ConditionEvaluationResult.disabled((String)reason);
        }
        return ENABLED;
    }
}

