/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.base.Precondition;

public class ListUtils {
    public static <T> boolean equalElements(List<T> list1, List<T> list2) {
        Precondition.checkNotNull(list1, "list1");
        Precondition.checkNotNull(list2, "list2");
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i).equals(list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static List<String> prefix(String prefix, List<String> list) {
        return ListUtils.prefix(prefix, (Optional<String>)Optional.absent(), list);
    }

    public static List<String> prefix(String prefix, String separator, List<String> list) {
        return ListUtils.prefix(prefix, (Optional<String>)Optional.of((Object)separator), list);
    }

    private static List<String> prefix(String prefix, Optional<String> separator, List<String> list) {
        Assert.noBlanks(prefix);
        Assert.noNulls(list, separator);
        Assert.noBlanks(separator);
        List newList = ListUtils.newArrayList();
        String separatorValue = separator.isPresent() ? (String)separator.get() : "";
        for (String element : list) {
            String value = prefix + separatorValue + element;
            newList.add(value);
        }
        return ImmutableList.copyOf(newList);
    }

    public static <T> List<T> newArrayList() {
        return ListUtils.newArrayList(new ArrayList());
    }

    public static <T> List<T> newArrayList(T element) {
        Assert.noNulls(element);
        List<T> list = ListUtils.newArrayList();
        list.add(element);
        return list;
    }

    public static <T> List<T> newArrayList(List<T> list) {
        return ListUtils.newArrayList(list, false);
    }

    public static <T> List<T> newImmutableArrayList(List<T> list) {
        return ListUtils.newArrayList(list, true);
    }

    public static <T> List<T> newArrayList(List<T> list, boolean immutable) {
        Assert.noNulls(list);
        if (immutable) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        return new ArrayList<T>(list);
    }

    public static void assertUniformRuntimeType(List<?> list) {
        Assert.noNulls(list);
        Assert.isTrue((list.size() > 0 ? 1 : 0) != 0, (String)"list is empty");
        Assert.isFalse(list.contains(null), "list contains null");
        Class<?> previous = list.get(0).getClass();
        for (int i = 1; i < list.size(); ++i) {
            Class<?> current = list.get(i).getClass();
            Assert.isTrue((current == previous ? 1 : 0) != 0, (String)("non-uniform runtime types at index " + i));
            previous = current;
        }
    }

    public static boolean equals(List<String> one, List<String> two) {
        return ListUtils.equals(one, two, false);
    }

    public static boolean equalsIgnoreCase(List<String> one, List<String> two) {
        return ListUtils.equals(one, two, true);
    }

    protected static boolean equals(List<String> one, List<String> two, boolean ignoreCase) {
        Assert.noNulls(one, two);
        if (one.size() != two.size()) {
            return false;
        }
        int size = one.size();
        for (int i = 0; i < size; ++i) {
            if (ListUtils.equal(one.get(i), two.get(i), ignoreCase)) continue;
            return false;
        }
        return true;
    }

    protected static boolean equal(String one, String two, boolean ignoreCase) {
        if (ignoreCase) {
            return StringUtils.equalsIgnoreCase((CharSequence)one, (CharSequence)two);
        }
        return StringUtils.equals((CharSequence)one, (CharSequence)two);
    }
}

