/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.ComparisonResults;
import org.kuali.common.util.LocationPropertiesContext;
import org.kuali.common.util.LocationType;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.TextMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class LocationUtils {
    private static final Logger logger = LoggerFactory.getLogger(LocationUtils.class);
    private static final String FILE_PREFIX = "file:";
    private static final String BACK_SLASH = "\\";
    private static final String FORWARD_SLASH = "/";
    private static final String SLASH_DOT_SLASH = "/./";
    private static final String DOT_DOT_SLASH = "../";
    private static final String SLASH_DOT_DOT = "/..";
    private static final String CLASSPATH = "classpath:";
    private static final String MD5 = "MD5";

    public static String getMD5Checksum(String location) {
        return LocationUtils.getChecksum(location, MD5);
    }

    public static String getMD5Checksum(File file) {
        return LocationUtils.getChecksum(LocationUtils.getCanonicalPath(file), MD5);
    }

    public static final PrintStream openPrintStream(File file) throws IOException {
        return new PrintStream(FileUtils.openOutputStream((File)file));
    }

    public static final Writer openWriter(File file) throws IOException {
        LocationUtils.touch(file);
        return new FileWriter(file);
    }

    public static final Writer openWriter(String location) throws IOException {
        return LocationUtils.openWriter(new File(location));
    }

    public static Properties getLocationProperties(LocationPropertiesContext context) {
        Assert.notNull((Object)context, (String)"context is null");
        Properties properties = context.getProperties();
        String keySuffix = context.getKeySuffix();
        String locationPropertiesSuffix = context.getLocationPropertiesSuffix();
        String encoding = context.getEncoding();
        Assert.notNull((Object)properties, (String)"properties is null");
        Assert.notNull((Object)keySuffix, (String)"keySuffix is null");
        Assert.notNull((Object)locationPropertiesSuffix, (String)"locationPropertiesSuffix is null");
        List<String> keys = PropertyUtils.getEndsWithKeys(properties, keySuffix);
        Properties locationProperties = new Properties();
        for (String key : keys) {
            String propertiesLocation;
            String location = properties.getProperty(key);
            if (!LocationUtils.exists(location) || !LocationUtils.exists(propertiesLocation = location + locationPropertiesSuffix)) continue;
            Properties p = PropertyUtils.load(propertiesLocation, encoding);
            locationProperties.putAll((Map<?, ?>)p);
        }
        logger.info("Located {} properties for {} location listings", (Object)locationProperties.size(), (Object)keys.size());
        return locationProperties;
    }

    public static TextMetaData getTextMetaData(File file) {
        return LocationUtils.getTextMetaData(LocationUtils.getCanonicalPath(file));
    }

    public static TextMetaData getTextMetaData(String location) {
        long lines = 0L;
        long size = 0L;
        BufferedReader in = null;
        try {
            in = LocationUtils.getBufferedReader(location);
            String s = in.readLine();
            while (s != null) {
                ++lines;
                size += (long)s.length();
                s = in.readLine();
            }
            TextMetaData textMetaData = new TextMetaData(lines, size);
            return textMetaData;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly((Reader)in);
        }
    }

    public static long getLineCount(File file) {
        return LocationUtils.getLineCount(file, null);
    }

    public static long getLineCount(File file, String encoding) {
        return LocationUtils.getLineCount(LocationUtils.getCanonicalPath(file));
    }

    @Deprecated
    public static long getLineCount(String location) {
        return LocationUtils.getLineCount(location, null);
    }

    public static long getLineCount(String location, String encoding) {
        long count = 0L;
        BufferedReader in = null;
        try {
            in = LocationUtils.getBufferedReader(location, encoding);
            while (in.readLine() != null) {
                ++count;
            }
            long l = count;
            return l;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error", e);
        }
        finally {
            IOUtils.closeQuietly((Reader)in);
        }
    }

    public static final void copyLocationsToFiles(List<String> locations, List<File> files) {
        Assert.isTrue((locations.size() == files.size() ? 1 : 0) != 0);
        for (int i = 0; i < locations.size(); ++i) {
            String location = locations.get(i);
            File destination = files.get(i);
            LocationUtils.copyLocationToFile(location, destination);
        }
    }

    public static final String getClasspathFilename(String location) {
        return LocationUtils.getClasspathFilenames(Arrays.asList(location)).get(0);
    }

    public static final List<String> getClasspathFilenames(List<String> locations) {
        ArrayList<String> classpathFilenames = new ArrayList<String>();
        for (String location : locations) {
            if (!LocationUtils.isClasspathLocation(location)) {
                throw new IllegalArgumentException(location + " must start with " + CLASSPATH);
            }
            classpathFilenames.add(StringUtils.substring((String)location, (int)CLASSPATH.length()));
        }
        return classpathFilenames;
    }

    public static final boolean isClasspathLocation(String location) {
        return StringUtils.startsWith((CharSequence)location, (CharSequence)CLASSPATH);
    }

    public static final List<String> getNormalizedPathFragments(String absolutePath, boolean directory) {
        String normalized = LocationUtils.getNormalizedAbsolutePath(absolutePath);
        String[] tokens = StringUtils.split((String)normalized, (String)FORWARD_SLASH);
        ArrayList<String> fragments = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append(FORWARD_SLASH);
        int length = directory ? tokens.length : tokens.length - 1;
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                sb.append(FORWARD_SLASH);
            }
            sb.append(tokens[i]);
            fragments.add(sb.toString());
        }
        return fragments;
    }

    public static final List<String> getCanonicalPaths(List<File> files) {
        ArrayList<String> paths = new ArrayList<String>();
        for (File file : files) {
            String path = LocationUtils.getCanonicalPath(file);
            paths.add(path);
        }
        return paths;
    }

    public static final List<String> getLocations(String location, LocationType type, String encoding) {
        switch (type) {
            case LOCATION: {
                return Collections.singletonList(location);
            }
            case LOCATIONLIST: {
                return LocationUtils.getLocations(location, encoding);
            }
        }
        throw new IllegalArgumentException("Location type '" + (Object)((Object)type) + "' is unknown");
    }

    public static final List<String> getLocations(String location, LocationType type) {
        return LocationUtils.getLocations(location, type, null);
    }

    public static final List<String> getLocations(String locationListing) {
        return LocationUtils.getLocations(Collections.singletonList(locationListing), null);
    }

    public static final List<String> getLocations(String locationListing, String encoding) {
        return LocationUtils.getLocations(Collections.singletonList(locationListing), encoding);
    }

    public static final List<String> getLocations(List<String> locationListings) {
        return LocationUtils.getLocations(locationListings, null);
    }

    public static final void copyLocationToFile(String location, File destination) {
        Assert.notNull((Object)location);
        Assert.notNull((Object)destination);
        logger.debug("Copying [{}]->[{}]", (Object)location, (Object)destination);
        InputStream in = null;
        try {
            in = LocationUtils.getInputStream(location);
            FileUtils.copyInputStreamToFile((InputStream)in, (File)destination);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static final List<File> getFiles(File dir, List<String> filenames) {
        ArrayList<File> files = new ArrayList<File>();
        for (String filename : filenames) {
            File file = new File(dir, filename);
            files.add(file);
        }
        return files;
    }

    public static final List<String> getFilenames(List<String> locations) {
        Assert.notNull(locations);
        ArrayList<String> filenames = new ArrayList<String>();
        for (String location : locations) {
            filenames.add(LocationUtils.getFilename(location));
        }
        return filenames;
    }

    public static final void validateLocationListing(String locationListing) {
        LocationUtils.validateLocationListings(Collections.singletonList(locationListing));
    }

    public static final void validateLocationListings(List<String> locationListings) {
        for (String locationListing : locationListings) {
            LocationUtils.validateLocation(locationListing);
            List<String> locations = LocationUtils.getLocations(locationListing);
            LocationUtils.validateLocations(locations);
        }
    }

    public static final void validateLocations(List<String> locations) {
        for (String location : locations) {
            LocationUtils.validateLocation(location);
        }
    }

    public static final void validateLocation(String location) {
        LocationUtils.validateLocation(location, "[" + location + "] does not exist");
    }

    public static final void validateLocation(String location, String message) {
        Assert.isTrue((boolean)LocationUtils.exists(location), (String)message);
    }

    public static final List<String> getLocations(List<String> locationListings, String encoding) {
        ArrayList<String> locations = new ArrayList<String>();
        for (String locationListing : locationListings) {
            List<String> lines = LocationUtils.readLines(locationListing, encoding);
            locations.addAll(lines);
        }
        return locations;
    }

    public static final String getCanonicalURLString(File file) {
        if (file == null) {
            return null;
        }
        String path = LocationUtils.getCanonicalPath(file);
        File canonical = new File(path);
        return LocationUtils.getURLString(canonical);
    }

    public static final void validateNormalizedPath(String originalPath, String normalizedPath) {
        if (CollectionUtils.containsAny(normalizedPath, Arrays.asList(SLASH_DOT_DOT, SLASH_DOT_SLASH, DOT_DOT_SLASH))) {
            throw new IllegalArgumentException("[" + originalPath + "] could not be normalized. Normalized path [" + normalizedPath + "]");
        }
    }

    public static final String getNormalizedAbsolutePath(String absolutePath) {
        if (absolutePath == null) {
            return null;
        }
        String replaced = StringUtils.replace((String)absolutePath, (String)BACK_SLASH, (String)FORWARD_SLASH);
        boolean absolute = StringUtils.startsWith((CharSequence)replaced, (CharSequence)FORWARD_SLASH);
        if (!absolute) {
            throw new IllegalArgumentException("[" + absolutePath + "] is not an absolute path.");
        }
        String prefixed = FILE_PREFIX + replaced;
        try {
            URI rawURI = new URI(prefixed);
            URI normalizedURI = rawURI.normalize();
            URL normalizedURL = normalizedURI.toURL();
            String externalForm = normalizedURL.toExternalForm();
            String trimmed = StringUtils.substring((String)externalForm, (int)FILE_PREFIX.length());
            LocationUtils.validateNormalizedPath(absolutePath, trimmed);
            return trimmed;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final String getURLString(File file) {
        if (file == null) {
            return null;
        }
        try {
            URI uri = file.toURI();
            URL url = uri.toURL();
            return url.toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final void forceMkdir(File file) {
        try {
            FileUtils.forceMkdir((File)file);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unexpected IO error", e);
        }
    }

    public static final void touch(File file) {
        try {
            FileUtils.touch((File)file);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unexpected IO error", e);
        }
    }

    public static final String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unexpected IO error", e);
        }
    }

    public static final boolean deleteFileQuietly(String filename) {
        File file = LocationUtils.getFileQuietly(filename);
        return FileUtils.deleteQuietly((File)file);
    }

    public static final File getFileQuietly(String filename) {
        if (filename == null) {
            return null;
        }
        return new File(filename);
    }

    public static final String toString(File file) {
        return LocationUtils.toString(file, null);
    }

    public static final String toString(File file, String encoding) {
        return LocationUtils.toString(LocationUtils.getCanonicalPath(file), encoding);
    }

    public static final String toString(String location) {
        return LocationUtils.toString(location, null);
    }

    public static final String toString(String location, String encoding) {
        InputStream in = null;
        try {
            in = LocationUtils.getInputStream(location);
            if (encoding == null) {
                String string = IOUtils.toString((InputStream)in);
                return string;
            }
            String string = IOUtils.toString((InputStream)in, (String)encoding);
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static final List<String> readLinesFromString(String s) {
        BufferedReader reader = LocationUtils.getBufferedReaderFromString(s);
        return LocationUtils.readLinesAndClose(reader);
    }

    public static final List<String> readLinesAndClose(InputStream in) {
        return LocationUtils.readLinesAndClose(in, null);
    }

    public static final List<String> readLinesAndClose(InputStream in, String encoding) {
        BufferedReader reader = null;
        try {
            reader = LocationUtils.getBufferedReader(in, encoding);
            List<String> list = LocationUtils.readLinesAndClose(reader);
            return list;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error", e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public static final List<String> readLinesAndClose(Reader reader) {
        try {
            List list = IOUtils.readLines((Reader)reader);
            return list;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error", e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public static final List<String> readLines(File file) {
        return LocationUtils.readLines(LocationUtils.getCanonicalPath(file));
    }

    public static final List<String> readLines(String location) {
        return LocationUtils.readLines(location, null);
    }

    public static final List<String> readLines(String location, String encoding) {
        BufferedReader reader = null;
        try {
            reader = LocationUtils.getBufferedReader(location, encoding);
            List<String> list = LocationUtils.readLinesAndClose(reader);
            return list;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error", e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public static final BufferedReader getBufferedReader(String location) throws IOException {
        return LocationUtils.getBufferedReader(location, null);
    }

    public static final BufferedReader getBufferedReader(String location, String encoding) throws IOException {
        try {
            InputStream in = LocationUtils.getInputStream(location);
            return LocationUtils.getBufferedReader(in, encoding);
        }
        catch (IOException e) {
            throw new IOException("Unexpected IO error", e);
        }
    }

    public static final BufferedReader getBufferedReaderFromString(String s) {
        return new BufferedReader(new StringReader(s));
    }

    public static final Writer getWriter(OutputStream out, String encoding) throws IOException {
        if (encoding == null) {
            return new BufferedWriter(new OutputStreamWriter(out));
        }
        return new BufferedWriter(new OutputStreamWriter(out, encoding));
    }

    public static final BufferedReader getBufferedReader(File file, String encoding) throws IOException {
        return LocationUtils.getBufferedReader(FileUtils.openInputStream((File)file), encoding);
    }

    public static final BufferedReader getBufferedReader(InputStream in, String encoding) throws IOException {
        if (encoding == null) {
            return new BufferedReader(new InputStreamReader(in));
        }
        return new BufferedReader(new InputStreamReader(in, encoding));
    }

    public static final boolean isExistingFile(String location) {
        if (location == null) {
            return false;
        }
        File file = new File(location);
        return file.exists();
    }

    public static final boolean exists(File file) {
        if (file == null) {
            return false;
        }
        String location = LocationUtils.getCanonicalPath(file);
        if (LocationUtils.isExistingFile(location)) {
            return true;
        }
        Resource resource = LocationUtils.getResource(location);
        return resource.exists();
    }

    public static void validateExists(List<String> locations) {
        StringBuilder sb = new StringBuilder();
        for (String location : locations) {
            if (LocationUtils.exists(location)) continue;
            sb.append("Location [" + location + "] does not exist\n");
        }
        if (sb.length() > 0) {
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public static final boolean exists(String location) {
        if (location == null) {
            return false;
        }
        if (LocationUtils.isExistingFile(location)) {
            return true;
        }
        Resource resource = LocationUtils.getResource(location);
        return resource.exists();
    }

    public static final InputStream getInputStream(String location) throws IOException {
        if (LocationUtils.isExistingFile(location)) {
            return FileUtils.openInputStream((File)new File(location));
        }
        Resource resource = LocationUtils.getResource(location);
        return resource.getInputStream();
    }

    public static final Resource getResource(String location) {
        if (location == null) {
            return null;
        }
        DefaultResourceLoader loader = new DefaultResourceLoader();
        return loader.getResource(location);
    }

    public static final String getFilename(String location) {
        if (location == null) {
            return null;
        }
        if (LocationUtils.isExistingFile(location)) {
            return LocationUtils.getFileQuietly(location).getName();
        }
        Resource resource = LocationUtils.getResource(location);
        return resource.getFilename();
    }

    public static final List<String> getAbsolutePaths(List<File> files) {
        ArrayList<String> results = new ArrayList<String>(files.size());
        for (File f : files) {
            results.add(f.getAbsolutePath());
        }
        return results;
    }

    public static final ComparisonResults getLocationListComparison(List<String> newLocations, List<String> originalLocations) {
        ComparisonResults result = new ComparisonResults();
        result.setAdded(new ArrayList<String>());
        result.setSame(new ArrayList<String>());
        result.setDeleted(new ArrayList<String>());
        for (String newLocation : newLocations) {
            if (originalLocations.contains(newLocation)) {
                result.getSame().add(newLocation);
                continue;
            }
            result.getAdded().add(newLocation);
        }
        result.getDeleted().addAll(originalLocations);
        result.getDeleted().removeAll(newLocations);
        return result;
    }

    public static String getChecksum(String location, String algorithm) {
        byte[] bytes = LocationUtils.createChecksum(location, algorithm);
        return LocationUtils.getChecksum(bytes, algorithm);
    }

    public static String getChecksum(byte[] bytes, String algorithm) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static byte[] createChecksum(String location, String algorithm) {
        InputStream in = null;
        try {
            in = LocationUtils.getInputStream(location);
            byte[] byArray = LocationUtils.createChecksum(in, algorithm);
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static byte[] createChecksum(InputStream in, String algorithm) throws IOException {
        try {
            int numRead;
            byte[] buffer = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance(algorithm);
            do {
                if ((numRead = in.read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            IOUtils.closeQuietly((InputStream)in);
            return complete.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unexpected message digest error", e);
        }
        catch (IOException e) {
            throw e;
        }
    }
}

