/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.kuali.common.util.equality.Equatable;

public class ObjectUtils {
    public static boolean equalsByToString(Object instance, Object other) {
        Preconditions.checkNotNull((Object)instance);
        if (instance == other) {
            return true;
        }
        if (ObjectUtils.notEqual(instance, other)) {
            return false;
        }
        return instance.toString().equals(other.toString());
    }

    public static <T extends Comparable<T>> boolean equalByComparison(T instance, Object object) {
        if (ObjectUtils.notEqual(instance, object)) {
            return false;
        }
        Comparable other = (Comparable)object;
        return instance.compareTo((Comparable)other) == 0;
    }

    public static boolean notEqual(Object instance, Object other) {
        Preconditions.checkNotNull((Object)instance);
        if (other == null) {
            return true;
        }
        return !instance.getClass().equals(other.getClass());
    }

    public static <T extends Equatable> boolean equal(T instance, Object other) {
        Preconditions.checkNotNull(instance);
        if (instance == other) {
            return true;
        }
        if (ObjectUtils.notEqual(instance, other)) {
            return false;
        }
        return ObjectUtils.equal(instance, (Equatable)other);
    }

    private static boolean equal(Equatable instance, Equatable other) {
        Object[] values2;
        Object[] values1 = instance.getEqualityValues();
        Preconditions.checkState((values1.length == (values2 = other.getEqualityValues()).length ? 1 : 0) != 0, (String)"value arrays must be the same. values1.length=%s values2.length=%s", (Object[])new Object[]{values1.length, values2.length});
        for (int i = 0; i < values1.length; ++i) {
            if (Objects.equals(values1[i], values2[i])) continue;
            return false;
        }
        return true;
    }
}

