/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.kuali.common.util.base.Exceptions;
import org.springframework.util.MethodInvoker;

public class ReflectionUtils
extends org.springframework.util.ReflectionUtils {
    public static List<Class<?>> getTypeHierarchy(Class<?> type) {
        ArrayList list = Lists.newArrayList();
        if (type.getSuperclass() != null) {
            list.addAll(ReflectionUtils.getTypeHierarchy(type.getSuperclass()));
        }
        list.add(type);
        return list;
    }

    public static Map<Class<?>, ParameterizedType> getAllParameterizedInterfaces(Class<?> type) {
        List<Type> list = ReflectionUtils.getAllGenericInterfaces(type);
        HashMap map = Maps.newHashMap();
        for (Type element : list) {
            if (!(element instanceof ParameterizedType)) continue;
            ParameterizedType pType = (ParameterizedType)element;
            Class interfaceClass = (Class)pType.getRawType();
            map.put(interfaceClass, pType);
        }
        return map;
    }

    public static List<Type> getAllGenericInterfaces(Class<?> type) {
        List<Class<?>> path = ReflectionUtils.getTypeHierarchy(type);
        ArrayList list = Lists.newArrayList();
        for (Class<?> element : path) {
            Object[] interfaces = element.getGenericInterfaces();
            list.addAll(ImmutableList.copyOf((Object[])interfaces));
        }
        return list;
    }

    public static boolean isFinal(Class<?> type) {
        return Modifier.isFinal(type.getModifiers());
    }

    public static boolean isFinal(Field field) {
        return Modifier.isFinal(field.getModifiers());
    }

    public static boolean isImmutableGuavaCollection(Class<?> type) {
        return ImmutableCollection.class.isAssignableFrom(type);
    }

    public static boolean isImmutableGuavaMap(Class<?> type) {
        return ImmutableMap.class.isAssignableFrom(type);
    }

    public static boolean isCollection(Field field) {
        return Collection.class.isAssignableFrom(field.getType());
    }

    public static boolean isStringCollection(Field field) {
        return ReflectionUtils.isCollection(field) && ReflectionUtils.hasMatchingParameterizedArgTypes(field, String.class);
    }

    public static boolean isMap(Field field) {
        return Map.class.isAssignableFrom(field.getType());
    }

    public static boolean isStringKeyedMap(Field field) {
        return ReflectionUtils.isMap(field) && ReflectionUtils.hasMatchingParameterizedArgTypes(field, String.class);
    }

    public static boolean isString(Field field) {
        return field.getType() == String.class;
    }

    public static boolean isCharSequence(Field field) {
        return ReflectionUtils.isCharSequence(field.getType());
    }

    public static boolean isCharSequence(Class<?> type) {
        return CharSequence.class.isAssignableFrom(type);
    }

    public static boolean isOptional(Field field) {
        return Optional.class.isAssignableFrom(field.getType());
    }

    public static boolean isOptionalString(Field field) {
        return ReflectionUtils.isOptional(field) && ReflectionUtils.hasMatchingParameterizedArgTypes(field, String.class);
    }

    public static boolean hasMatchingParameterizedArgTypes(Field field, Class<?> ... expectedTypeArguments) {
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            return ReflectionUtils.hasMatchingActualTypeArguments(parameterizedType, expectedTypeArguments);
        }
        return false;
    }

    protected static boolean hasMatchingActualTypeArguments(ParameterizedType type, Class<?> ... expectedTypeArguments) {
        Type[] actualTypeArguments = type.getActualTypeArguments();
        for (int i = 0; i < expectedTypeArguments.length; ++i) {
            Class<?> expectedTypeArgument = expectedTypeArguments[i];
            if (i >= actualTypeArguments.length) {
                return false;
            }
            if (!(actualTypeArguments[i] instanceof Class)) {
                return false;
            }
            Class actualTypeArgument = (Class)actualTypeArguments[i];
            if (actualTypeArgument == expectedTypeArgument) continue;
            return false;
        }
        return true;
    }

    public static void validateIsSuperType(Class<?> superType, Class<?> type) {
        ReflectionUtils.checkSuperType(superType, type);
    }

    public static Class<?> checkSuperType(Class<?> superType, Class<?> type) {
        boolean expression = ReflectionUtils.isSuperType(superType, type);
        Preconditions.checkArgument((boolean)expression, (String)"[%s] must descend from (or be) [%s]", (Object[])new Object[]{type.getCanonicalName(), superType.getCanonicalName()});
        return superType;
    }

    public static boolean isSuperType(Class<?> superType, Class<?> type) {
        return superType.isAssignableFrom(type);
    }

    @Deprecated
    public static <T extends Annotation> Optional<T> getAnnotation(Class<?> type, Class<T> annotationClass) {
        return Optional.fromNullable(type.getAnnotation(annotationClass));
    }

    @Deprecated
    public static <T extends Annotation> Optional<T> getAnnotation(Field field, Class<T> annotationClass) {
        return Optional.fromNullable(field.getAnnotation(annotationClass));
    }

    public static List<Class<?>> getDeclarationHierarchy(Class<?> type) {
        ArrayList hierarchy = new ArrayList();
        Class<?> declaringClass = type.getDeclaringClass();
        if (declaringClass != null) {
            hierarchy.addAll(ReflectionUtils.getDeclarationHierarchy(declaringClass));
        }
        hierarchy.add(type);
        return hierarchy;
    }

    public static String getDeclarationPath(Class<?> type) {
        List<Class<?>> hierarchy = ReflectionUtils.getDeclarationHierarchy(type);
        ArrayList names = Lists.newArrayList();
        for (Class<?> element : hierarchy) {
            names.add(element.getSimpleName());
        }
        return Joiner.on((char)'.').join((Iterable)names);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<Object> extractFieldValue(Field field, Object instance) {
        Field field2 = field;
        synchronized (field2) {
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            try {
                Optional optional = Optional.fromNullable((Object)field.get(instance));
                return optional;
            }
            catch (IllegalAccessException e) {
                throw Exceptions.illegalState(e);
            }
            finally {
                if (!accessible) {
                    field.setAccessible(false);
                }
            }
        }
    }

    @Deprecated
    public static Optional<Object> get(Field field, Object instance) {
        return ReflectionUtils.get(field, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(Object instance, Field field, Object value) {
        Field field2 = field;
        synchronized (field2) {
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            try {
                field.set(instance, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            finally {
                if (!accessible) {
                    field.setAccessible(false);
                }
            }
        }
    }

    public static Set<Field> getFields(Class<?> type) {
        return ImmutableSet.copyOf((Object[])type.getDeclaredFields());
    }

    public static Set<Field> getFields(Class<?> type, boolean includeInheritedFields) {
        if (includeInheritedFields) {
            return ReflectionUtils.getAllFields(type);
        }
        return ReflectionUtils.getFields(type);
    }

    @Deprecated
    public static Map<String, Field> getNameMap(Set<Field> fields) {
        HashMap map = Maps.newHashMap();
        for (Field field : fields) {
            map.put(field.getName(), field);
        }
        return map;
    }

    public static Map<String, Field> getNameMap(List<Field> fields) {
        HashMap map = Maps.newHashMap();
        for (Field field : fields) {
            map.put(field.getName(), field);
        }
        return map;
    }

    public static Map<String, Field> getUniqueFieldNames(Class<?> type) {
        Set<Field> fields = ReflectionUtils.getAllFields(type);
        Preconditions.checkArgument((boolean)ReflectionUtils.hasUniqueFieldNames(fields), (Object)"[%s] contains duplicate field names");
        return ReflectionUtils.getNameMap(Lists.newArrayList(fields));
    }

    public static Map<String, Field> getFields(Class<?> type, Set<String> fieldNames) {
        HashMap fields = Maps.newHashMap();
        for (String fieldName : fieldNames) {
            try {
                fields.put(fieldName, type.getDeclaredField(fieldName));
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException(e);
            }
            catch (SecurityException e) {
                throw new IllegalStateException(e);
            }
        }
        return fields;
    }

    public static Set<Field> getAllFields(Class<?> type) {
        HashSet fields = Sets.newHashSet();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            Set<Field> set = ReflectionUtils.getFields(c);
            fields.addAll(set);
        }
        return ImmutableSet.copyOf((Collection)fields);
    }

    public static List<Field> getAllFieldsList(Class<?> type) {
        ArrayList fields = Lists.newArrayList();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            Set<Field> set = ReflectionUtils.getFields(c);
            fields.addAll(set);
        }
        return ImmutableList.copyOf((Collection)Lists.reverse((List)fields));
    }

    public static boolean hasUniqueFieldNames(Class<?> type) {
        return ReflectionUtils.hasUniqueFieldNames(ReflectionUtils.getAllFields(type));
    }

    public static boolean hasUniqueFieldNames(Set<Field> fields) {
        return ReflectionUtils.getNameMap(Lists.newArrayList(fields)).size() == fields.size();
    }

    public static boolean hasUniqueFieldNames(List<Field> fields) {
        return ReflectionUtils.getNameMap(fields).size() == fields.size();
    }

    public static Map<String, Object> describe(Object bean) {
        try {
            return BeanUtils.describe((Object)bean);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void copyProperty(Object bean, String name, Object value) {
        try {
            BeanUtils.copyProperty((Object)bean, (String)name, (Object)value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Object invokeMethod(Class<?> targetClass, String targetMethod, Object ... arguments) {
        MethodInvoker invoker = new MethodInvoker();
        invoker.setTargetClass(targetClass);
        invoker.setTargetMethod(targetMethod);
        invoker.setArguments(arguments);
        return ReflectionUtils.invoke(invoker);
    }

    public static Object invokeMethod(Object targetObject, String targetMethod, Object ... arguments) {
        MethodInvoker invoker = new MethodInvoker();
        invoker.setTargetObject(targetObject);
        invoker.setTargetMethod(targetMethod);
        invoker.setArguments(arguments);
        return ReflectionUtils.invoke(invoker);
    }

    public static Object invoke(MethodInvoker invoker) {
        try {
            invoker.prepare();
            return invoker.invoke();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> Class<? extends T> getTypedClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T newInstance(String className) {
        Class<?> clazz = ReflectionUtils.getClass(className);
        return (T)ReflectionUtils.newInstance(clazz);
    }

    public static <T> T newInstance(Class<T> instanceClass) {
        try {
            return instanceClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unexpected error", e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Unexpected error", e);
        }
    }
}

