/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.base;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class Precondition {
    private static final String NOT_NULL_MSG = "'%s' cannot be null";
    private static final String EXISTS_MSG = "[%s] does not exist";
    private static final String IS_DIR_MSG = "[%s] is not an existing directory";
    private static final String IS_FILE_MSG = "[%s] is not an existing file";
    private static final String NOT_BLANK_MSG = "'%s' cannot be blank";
    private static final String MIN_MSG = "%s not allowed. '%s' must be greater than or equal to %s";
    private static final String MAX_MSG = "%s not allowed. '%s' must be less than or equal to %s";
    private static final String EQUALS_MSG = "[%s] not allowed. '%s' must be equal to [%s]";
    private static final String ARG_NAME = "argName";

    public static File checkExists(File arg, String argName) {
        Precondition.checkNotBlank(argName, ARG_NAME);
        Precondition.checkNotNull(arg, argName);
        Preconditions.checkArgument((boolean)arg.exists(), (String)EXISTS_MSG, (Object[])new Object[]{arg});
        return arg;
    }

    public static File checkIsDir(File arg, String argName) {
        Preconditions.checkArgument((boolean)Precondition.checkExists(arg, argName).isDirectory(), (String)IS_DIR_MSG, (Object[])new Object[]{arg});
        return arg;
    }

    public static File checkIsFile(File arg, String argName) {
        Preconditions.checkArgument((boolean)Precondition.checkExists(arg, argName).isFile(), (String)IS_FILE_MSG, (Object[])new Object[]{arg});
        return arg;
    }

    public static <T> T checkNotNull(T arg, String argName) {
        return (T)Preconditions.checkNotNull(arg, (String)NOT_NULL_MSG, (Object[])new Object[]{Precondition.checkNotBlank(argName, ARG_NAME)});
    }

    public static String checkNotBlank(String arg, String argName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)argName), (String)NOT_BLANK_MSG, (Object[])new Object[]{ARG_NAME});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)arg), (String)NOT_BLANK_MSG, (Object[])new Object[]{argName});
        return arg;
    }

    public static Optional<String> checkNotBlank(Optional<String> arg, String argName) {
        if (arg.isPresent()) {
            Precondition.checkNotBlank((String)arg.get(), argName);
        }
        return arg;
    }

    public static Optional<Integer> checkMin(Optional<Integer> arg, int min, String argName) {
        if (arg.isPresent()) {
            Precondition.checkMin((Integer)arg.get(), min, argName);
        }
        return arg;
    }

    public static Optional<Long> checkMin(Optional<Long> arg, long min, String argName) {
        if (arg.isPresent()) {
            Precondition.checkMin((Long)arg.get(), min, argName);
        }
        return arg;
    }

    public static int checkMax(int arg, int max, String argName) {
        Precondition.checkNotBlank(argName, ARG_NAME);
        Preconditions.checkArgument((arg <= max ? 1 : 0) != 0, (String)MAX_MSG, (Object[])new Object[]{arg, argName, max});
        return arg;
    }

    public static long checkMax(long arg, long max, String argName) {
        Precondition.checkNotBlank(argName, ARG_NAME);
        Preconditions.checkArgument((arg <= max ? 1 : 0) != 0, (String)MAX_MSG, (Object[])new Object[]{arg, argName, max});
        return arg;
    }

    public static int checkRange(int arg, int min, int max, String argName) {
        return Precondition.checkMin(Precondition.checkMax(arg, max, argName), min, argName);
    }

    public static int checkMin(int arg, int min, String argName) {
        Precondition.checkNotBlank(argName, ARG_NAME);
        Preconditions.checkArgument((arg >= min ? 1 : 0) != 0, (String)MIN_MSG, (Object[])new Object[]{arg, argName, min});
        return arg;
    }

    public static long checkMin(long arg, long min, String argName) {
        Precondition.checkNotBlank(argName, ARG_NAME);
        Preconditions.checkArgument((arg >= min ? 1 : 0) != 0, (String)MIN_MSG, (Object[])new Object[]{arg, argName, min});
        return arg;
    }

    public static <T> T checkEquals(T arg, T expected, String argName) {
        Precondition.checkNotNull(arg, Precondition.checkNotBlank(argName, ARG_NAME));
        Precondition.checkNotNull(expected, "expected");
        Preconditions.checkArgument((boolean)arg.equals(expected), (String)EQUALS_MSG, (Object[])new Object[]{argName, arg, expected});
        return arg;
    }

    public static long checkEquals(long arg, long expected, String argName) {
        Precondition.checkNotBlank(argName, ARG_NAME);
        Preconditions.checkArgument((arg == expected ? 1 : 0) != 0, (String)EQUALS_MSG, (Object[])new Object[]{argName, arg, expected});
        return arg;
    }

    public static int checkEquals(int arg, int expected, String argName) {
        Precondition.checkNotBlank(argName, ARG_NAME);
        Preconditions.checkArgument((arg == expected ? 1 : 0) != 0, (String)EQUALS_MSG, (Object[])new Object[]{argName, arg, expected});
        return arg;
    }

    public static void checkTruths(int expected, boolean ... expressions) {
        Precondition.checkMin(expected, 0, "expected");
        Preconditions.checkArgument((expressions.length > 0 ? 1 : 0) != 0, (Object)"must supply at least 1 expression");
        int actual = 0;
        for (boolean expression : expressions) {
            actual = expression ? actual + 1 : actual;
        }
        Preconditions.checkArgument((expected == actual ? 1 : 0) != 0, (String)"expected %s of %s expression(s) to be true, but %s were true instead", (Object[])new Object[]{expected, expressions.length, actual});
    }

    public static <I extends Iterable<T>, T> I checkSize(I iterable, int expected) {
        int actual = Iterables.size(iterable);
        Preconditions.checkArgument((expected == actual ? 1 : 0) != 0, (String)"expected exactly %s element(s) but there were %s instead", (Object[])new Object[]{expected, actual});
        return iterable;
    }
}

