/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.base;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.base.Exceptions;

public class Threads {
    public static long checkedWait(Stopwatch sw, long timeout, long sleep) {
        Preconditions.checkState((sw.elapsed(TimeUnit.MILLISECONDS) <= timeout ? 1 : 0) != 0, (Object)"wait timeout exceeded");
        return Threads.sleep(sleep);
    }

    public static long sleep(String time) {
        return Threads.sleep(FormatUtils.getMillis(time));
    }

    public static long sleep(long millis) {
        try {
            Thread.sleep(millis);
            return millis;
        }
        catch (InterruptedException e) {
            throw Exceptions.illegalState(e);
        }
    }

    public static void start(List<Thread> threads) {
        for (Thread thread : threads) {
            thread.start();
        }
    }

    public static void join(List<Thread> threads) {
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw Exceptions.illegalState(e, "unexpected interruption [thread id:%s] [thread name:%s]", thread.getId(), thread.getName());
            }
        }
    }
}

