/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.channel.impl;

import com.google.common.base.Optional;
import com.jcraft.jsch.ChannelExec;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.plexus.util.cli.StreamFeeder;
import org.kuali.common.util.Assert;
import org.kuali.common.util.channel.model.CommandContext;
import org.kuali.common.util.stream.StreamPumper;

public final class StreamHandler {
    private final CommandContext context;
    private Optional<StreamFeeder> inputFeeder;
    private StreamPumper outputPumper;
    private StreamPumper errorPumper;
    private boolean open = false;
    private boolean pumping = false;
    private boolean done = false;

    public StreamHandler(CommandContext context) {
        Assert.noNulls(context);
        this.context = context;
    }

    public void openStreams(ChannelExec exec, String encoding) throws IOException {
        Assert.isFalse(this.open, "Already open");
        Assert.noNulls(exec);
        this.inputFeeder = this.getInputFeeder(this.context, exec);
        this.outputPumper = new StreamPumper(exec.getInputStream(), encoding, this.context.getStdout());
        this.errorPumper = new StreamPumper(exec.getErrStream(), encoding, this.context.getStderr());
        this.open = true;
    }

    public void startPumping() {
        Assert.isTrue((boolean)this.open, (String)"Not open");
        Assert.isFalse(this.pumping, "Already pumping");
        Assert.noNulls(new Object[]{this.inputFeeder, this.outputPumper, this.errorPumper});
        if (this.inputFeeder.isPresent()) {
            ((StreamFeeder)this.inputFeeder.get()).start();
        }
        this.errorPumper.start();
        this.outputPumper.start();
        this.pumping = true;
    }

    public void waitUntilDone() throws InterruptedException {
        Assert.isTrue((boolean)this.open, (String)"Not open");
        Assert.isTrue((boolean)this.pumping, (String)"Not pumping");
        Assert.isFalse(this.done, "Already done");
        if (this.inputFeeder.isPresent()) {
            ((StreamFeeder)this.inputFeeder.get()).waitUntilDone();
        }
        this.outputPumper.waitUntilDone();
        this.errorPumper.waitUntilDone();
        this.done = true;
    }

    public void validate() throws InterruptedException {
        Assert.isTrue((boolean)this.done, (String)"Not done");
        if (this.outputPumper.getException() != null) {
            throw new IllegalStateException("Error inside systemOut parser", this.outputPumper.getException());
        }
        if (this.errorPumper.getException() != null) {
            throw new IllegalStateException("Error inside systemErr parser", this.errorPumper.getException());
        }
    }

    public void disableQuietly() {
        if (this.inputFeeder != null && this.inputFeeder.isPresent()) {
            ((StreamFeeder)this.inputFeeder.get()).disable();
        }
        if (this.errorPumper != null) {
            this.errorPumper.disable();
        }
        if (this.outputPumper != null) {
            this.outputPumper.disable();
        }
    }

    public void closeQuietly() {
        if (this.inputFeeder != null && this.inputFeeder.isPresent()) {
            ((StreamFeeder)this.inputFeeder.get()).close();
        }
        if (this.errorPumper != null) {
            this.errorPumper.close();
        }
        if (this.outputPumper != null) {
            this.outputPumper.close();
        }
    }

    public CommandContext getContext() {
        return this.context;
    }

    protected Optional<StreamFeeder> getInputFeeder(CommandContext context, ChannelExec exec) throws IOException {
        if (context.getStdin().isPresent()) {
            StreamFeeder feeder = new StreamFeeder((InputStream)context.getStdin().get(), exec.getOutputStream());
            return Optional.of((Object)feeder);
        }
        return Optional.absent();
    }
}

