/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.channel.model;

import com.google.common.base.Optional;
import org.kuali.common.util.Assert;
import org.kuali.common.util.channel.model.Status;

public final class RemoteFile {
    private final String absolutePath;
    private final Optional<Integer> groupId;
    private final Optional<Integer> userId;
    private final Optional<Integer> permissions;
    private final Optional<Long> size;
    private final boolean directory;
    private final Optional<Status> status;

    private RemoteFile(Builder builder) {
        this.absolutePath = builder.absolutePath;
        this.groupId = builder.groupId;
        this.userId = builder.userId;
        this.permissions = builder.permissions;
        this.size = builder.size;
        this.directory = builder.directory;
        this.status = builder.status;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public Optional<Integer> getGroupId() {
        return this.groupId;
    }

    public Optional<Integer> getUserId() {
        return this.userId;
    }

    public Optional<Integer> getPermissions() {
        return this.permissions;
    }

    public Optional<Long> getSize() {
        return this.size;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public Optional<Status> getStatus() {
        return this.status;
    }

    public static class Builder {
        private final String absolutePath;
        private Optional<Integer> groupId = Optional.absent();
        private Optional<Integer> userId = Optional.absent();
        private Optional<Integer> permissions = Optional.absent();
        private Optional<Long> size = Optional.absent();
        private boolean directory = false;
        private Optional<Status> status = Optional.absent();

        public Builder(String absolutePath) {
            this.absolutePath = absolutePath;
        }

        public Builder clone(RemoteFile other) {
            this.groupId = other.groupId;
            this.userId = other.userId;
            this.permissions = other.permissions;
            this.size = other.size;
            this.directory = other.directory;
            this.status = other.status;
            return this;
        }

        public Builder groupId(int groupId) {
            this.groupId = Optional.of((Object)groupId);
            return this;
        }

        public Builder userId(int userId) {
            this.userId = Optional.of((Object)userId);
            return this;
        }

        public Builder permissions(int permissions) {
            this.permissions = Optional.of((Object)permissions);
            return this;
        }

        public Builder size(long size) {
            this.size = Optional.of((Object)size);
            return this;
        }

        public Builder directory(boolean directory) {
            this.directory = directory;
            return this;
        }

        public Builder status(Status status) {
            this.status = Optional.of((Object)((Object)status));
            return this;
        }

        public RemoteFile build() {
            Assert.noBlanks(this.absolutePath);
            Assert.noNulls(this.groupId, this.userId, this.permissions, this.size, this.directory, this.status);
            if (this.size.isPresent()) {
                Assert.notNegative((Long)this.size.get());
            }
            return new RemoteFile(this);
        }
    }
}

