/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.config.service;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.Mode;
import org.kuali.common.util.ModeUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.config.ConfigUtils;
import org.kuali.common.util.config.ContextConfig;
import org.kuali.common.util.config.Location;
import org.kuali.common.util.config.ProjectConfig;
import org.kuali.common.util.config.ProjectConfigContainer;
import org.kuali.common.util.config.ProjectConfigContainerNullifier;
import org.kuali.common.util.config.service.ConfigService;
import org.kuali.common.util.project.ProjectService;
import org.kuali.common.util.project.ProjectUtils;
import org.kuali.common.util.project.model.Project;
import org.kuali.common.util.property.Constants;
import org.kuali.common.util.property.processor.OverrideProcessor;
import org.kuali.common.util.xml.service.XmlService;
import org.springframework.util.PropertyPlaceholderHelper;

@Deprecated
public abstract class AbstractCachingConfigService
implements ConfigService {
    private static final String METAINF = "META-INF";
    private static final String CLASSPATH = "classpath:";
    private static final String CLASSPATH_PREFIX_KEY = "classpath.prefix";
    private static final String CONFIG = "config";
    private static final String PROPS = "metadata.properties";
    private static final String DELIMITER = ":";
    private static final PropertyPlaceholderHelper HELPER = Constants.DEFAULT_PROPERTY_PLACEHOLDER_HELPER;
    private final ProjectService projectService;
    private final XmlService xmlService;

    public AbstractCachingConfigService(ProjectService projectService, XmlService xmlService) {
        Assert.noNulls(projectService, xmlService);
        this.projectService = projectService;
        this.xmlService = xmlService;
    }

    @Override
    public Properties getProperties(String configId) {
        return this.getProperties(configId, (Properties)null);
    }

    @Override
    public Properties getProperties(List<String> configIds) {
        return this.getProperties(configIds, null);
    }

    @Override
    public Properties getProperties(String configId, Properties overrides) {
        return this.getProperties(CollectionUtils.toEmptyList(configId), overrides);
    }

    @Override
    public Properties getProperties(List<String> configIds, Properties overrides) {
        List<ProjectConfig> requests = ConfigUtils.getProjectConfigs(CollectionUtils.toEmptyList(configIds));
        return this.loadProperties(requests, PropertyUtils.toEmpty(overrides));
    }

    protected abstract ProjectConfigContainer getCachedConfig(String var1, String var2);

    protected abstract void clearCache();

    protected abstract ProjectConfigContainer getProjectConfig(String var1, String var2);

    protected abstract String getFilename();

    protected Properties loadProperties(List<ProjectConfig> requests, Properties overrides) {
        List<Location> locations = this.getLocations(requests);
        Properties properties = new Properties();
        Properties global = PropertyUtils.getGlobalProperties();
        for (Location location : locations) {
            Properties resolver = PropertyUtils.combine(properties, overrides, global);
            String resolvedLocation = HELPER.replacePlaceholders(location.getValue(), resolver);
            if (LocationUtils.exists(resolvedLocation)) {
                Properties loaded = PropertyUtils.load(resolvedLocation, location.getEncoding());
                new OverrideProcessor(Mode.INFORM, loaded, 2).process(properties);
                continue;
            }
            ModeUtils.validate(location.getMissingMode(), "Non-existent location [" + resolvedLocation + "]");
        }
        new OverrideProcessor(Mode.INFORM, overrides, 2).process(properties);
        new OverrideProcessor(Mode.INFORM, global, 2).process(properties);
        PropertyUtils.decrypt(properties);
        PropertyUtils.resolve(properties);
        return properties;
    }

    protected Properties getBaseFilterProperties() {
        return new Properties();
    }

    protected ProjectConfigContainer loadMetadata(String groupId, String artifactId) {
        Assert.notNull((Object)this.projectService, (String)"projectService is null");
        Project project = this.projectService.getProject(groupId, artifactId);
        String location = this.getMetadataConfigFilePath(project, this.getFilename());
        Assert.exists(location, "[" + location + "] does not exist");
        Properties properties = this.getBaseFilterProperties();
        Properties projectProperties = this.getFilterProperties(project);
        properties.putAll((Map<?, ?>)projectProperties);
        String encoding = ProjectUtils.getEncoding(project);
        String content = this.getFilteredContent(location, properties, encoding);
        return this.getProjectConfig(content, encoding);
    }

    protected List<Location> getLocations(List<ProjectConfig> configs) {
        ArrayList<Location> locations = new ArrayList<Location>();
        for (ProjectConfig config : configs) {
            List<Location> requestLocations = this.findLocations(config);
            locations.addAll(requestLocations);
        }
        return locations;
    }

    protected List<Location> findLocations(ProjectConfig request) {
        ProjectConfigContainer config = this.getCachedConfig(request.getGroupId(), request.getArtifactId());
        if (StringUtils.isBlank((CharSequence)request.getContextId())) {
            return new ArrayList<Location>(CollectionUtils.toEmptyList(config.getLocations()));
        }
        String[] tokens = StringUtils.split((String)request.getContextId(), (String)DELIMITER);
        List<ContextConfig> contexts = config.getContexts();
        ContextConfig context = null;
        for (String token : tokens) {
            context = this.findContextConfig(contexts, token);
            contexts = context.getContexts();
        }
        return context.getLocations();
    }

    protected ContextConfig findContextConfig(List<ContextConfig> contexts, String contextId) {
        for (ContextConfig context : contexts) {
            if (!StringUtils.equals((CharSequence)contextId, (CharSequence)context.getId())) continue;
            return context;
        }
        throw new IllegalArgumentException("Unknown contextId [" + contextId + "]");
    }

    protected String getMetadataConfigFilePath(Project project, String filename) {
        String resourcePath = ProjectUtils.getResourcePath(project.getGroupId(), project.getArtifactId());
        return "classpath:META-INF/" + resourcePath + "/" + CONFIG + "/" + filename;
    }

    protected String getFilteredContent(String location, Properties properties, String encoding) {
        PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("${", "}", DELIMITER, true);
        String originalContent = LocationUtils.toString(location, encoding);
        String filteredContent = helper.replacePlaceholders(originalContent, properties);
        return filteredContent;
    }

    protected Properties getFilterProperties(Project project) {
        String classpathPrefix = ProjectUtils.getClasspathPrefix(project.getGroupId(), project.getArtifactId());
        Properties duplicate = PropertyUtils.duplicate(project.getProperties());
        duplicate.setProperty(CLASSPATH_PREFIX_KEY, classpathPrefix);
        String location = this.getMetadataConfigFilePath(project, PROPS);
        Properties metadata = new Properties();
        if (LocationUtils.exists(location)) {
            String encoding = ProjectUtils.getEncoding(project);
            metadata = PropertyUtils.load(location, encoding);
        }
        duplicate.putAll((Map<?, ?>)metadata);
        return duplicate;
    }

    protected void store(File file, ProjectConfigContainer config) {
        Assert.notNull((Object)file, (String)"file is null");
        Assert.notNull((Object)config, (String)"config is null");
        ProjectConfigContainer clone = new ProjectConfigContainer(config);
        ProjectConfigContainerNullifier nullifier = new ProjectConfigContainerNullifier();
        nullifier.nullify();
        this.xmlService.write(file, (Object)clone);
    }

    public ProjectService getProjectService() {
        return this.projectService;
    }

    public XmlService getXmlService() {
        return this.xmlService;
    }
}

