/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.enc;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.jasypt.util.text.BasicTextEncryptor;
import org.jasypt.util.text.StrongTextEncryptor;
import org.jasypt.util.text.TextEncryptor;
import org.kuali.common.util.Assert;
import org.kuali.common.util.Str;
import org.kuali.common.util.base.Exceptions;
import org.kuali.common.util.base.Precondition;
import org.kuali.common.util.enc.EncStrength;
import org.kuali.common.util.enc.EncryptionService;

@Deprecated
public class EncUtils {
    private static final String MAGIC_PREFIX = "enc--";
    private static final String PREFIX = "ENC(";
    private static final String SUFFIX = ")";
    public static final Optional<EncryptionService> ABSENT = Optional.absent();

    public static boolean isEncrypted(String text) {
        if (text == null) {
            return false;
        }
        return Str.matches(text, PREFIX, SUFFIX) || text.startsWith(MAGIC_PREFIX);
    }

    public static String unwrap(String text) {
        Assert.noBlanks(text);
        Assert.encrypted(text);
        if (text.startsWith(MAGIC_PREFIX)) {
            return Str.removePrefix(text, MAGIC_PREFIX);
        }
        return Str.remove(text, PREFIX, SUFFIX);
    }

    public static String wrap(String text) {
        Assert.noBlanks(text);
        Assert.notEncrypted(text);
        return MAGIC_PREFIX + text;
    }

    public static TextEncryptor getTextEncryptor(String password) {
        return EncUtils.getTextEncryptor(password, EncStrength.DEFAULT_ENCRYPTION_STRENGTH);
    }

    public static TextEncryptor getTextEncryptor(String password, EncStrength strength) {
        Precondition.checkNotBlank(password, "password");
        Precondition.checkNotNull(strength, "strength");
        switch (strength) {
            case BASIC: {
                BasicTextEncryptor basic = new BasicTextEncryptor();
                basic.setPassword(password);
                return basic;
            }
            case STRONG: {
                StrongTextEncryptor strong = new StrongTextEncryptor();
                strong.setPassword(password);
                return strong;
            }
        }
        throw Exceptions.illegalArgument("encryption strength [%s] is unknown", new Object[]{strength});
    }

    public static Optional<String> decrypt(Optional<EncryptionService> enc, Optional<String> string) {
        if (enc.isPresent() && string.isPresent()) {
            return Optional.of((Object)((EncryptionService)enc.get()).decrypt((String)string.get()));
        }
        return string;
    }

    public static String decrypt(Optional<EncryptionService> enc, String string) {
        return (String)EncUtils.decrypt(enc, (Optional<String>)Optional.of((Object)string)).get();
    }

    public static List<String> decrypt(Optional<EncryptionService> enc, List<String> strings) {
        if (!enc.isPresent()) {
            return strings;
        }
        ArrayList<String> decrypted = new ArrayList<String>();
        for (String string : strings) {
            decrypted.add(((EncryptionService)enc.get()).decrypt(string));
        }
        return ImmutableList.copyOf(decrypted);
    }

    public static List<String> decrypt(EncryptionService enc, List<String> strings) {
        return EncUtils.decrypt((Optional<EncryptionService>)Optional.of((Object)enc), strings);
    }

    public static Optional<String> decrypt(EncryptionService enc, Optional<String> optional) {
        return EncUtils.decrypt((Optional<EncryptionService>)Optional.of((Object)enc), optional);
    }
}

