/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.enc;

import com.google.common.base.Optional;
import org.kuali.common.util.Assert;
import org.kuali.common.util.enc.EncStrength;
import org.kuali.common.util.nullify.NullUtils;

@Deprecated
public final class EncryptionContext {
    public static final EncryptionContext DEFAULT = new Builder().build();
    private final boolean enabled;
    private final boolean passwordRequired;
    private final boolean removePasswordSystemProperty;
    private final Optional<String> password;
    private final Optional<String> passwordKey;
    private final EncStrength strength;

    private EncryptionContext(Builder builder) {
        this.enabled = builder.enabled;
        this.passwordKey = builder.passwordKey;
        this.passwordRequired = builder.passwordRequired;
        this.strength = builder.strength;
        this.removePasswordSystemProperty = builder.removePasswordSystemProperty;
        this.password = builder.password;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Optional<String> getPassword() {
        return this.password;
    }

    public EncStrength getStrength() {
        return this.strength;
    }

    public boolean isPasswordRequired() {
        return this.passwordRequired;
    }

    public Optional<String> getPasswordKey() {
        return this.passwordKey;
    }

    public boolean isRemovePasswordSystemProperty() {
        return this.removePasswordSystemProperty;
    }

    public static class Builder {
        private boolean passwordRequired = false;
        private boolean removePasswordSystemProperty = true;
        private Optional<String> password = Optional.absent();
        private Optional<String> passwordKey = Optional.absent();
        private EncStrength strength = EncStrength.BASIC;
        private boolean enabled = false;

        public Builder removePasswordSystemProperty(boolean removePasswordSystemProperty) {
            this.removePasswordSystemProperty = removePasswordSystemProperty;
            return this;
        }

        public Builder passwordRequired(boolean passwordRequired) {
            this.passwordRequired = passwordRequired;
            return this;
        }

        public Builder password(String password) {
            this.password = NullUtils.toAbsent(password);
            return this;
        }

        public Builder passwordKey(String passwordKey) {
            this.passwordKey = NullUtils.toAbsent(passwordKey);
            return this;
        }

        public Builder strength(EncStrength strength) {
            this.strength = strength;
            return this;
        }

        public EncryptionContext build() {
            Assert.noNulls(new Object[]{this.password, this.passwordKey, this.strength, this.enabled});
            this.enabled = this.password.isPresent();
            if (this.passwordRequired) {
                Assert.isTrue((boolean)this.password.isPresent(), (String)"Encryption password is required");
            }
            if (this.password.isPresent()) {
                Assert.noBlanks((String)this.password.get());
            }
            return new EncryptionContext(this);
        }
    }
}

