/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.encrypt;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.kuali.common.util.base.Exceptions;
import org.kuali.common.util.encrypt.Encryption;
import org.kuali.common.util.file.CanonicalFile;

public final class EncryptionMain {
    private static final String FS = File.separator;
    private static final String USER_HOME_TOKEN = "~" + FS;
    private static final String USER_HOME_REPLACEMENT = System.getProperty("user.home") + FS;

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            EncryptionMain.usage();
            System.exit(1);
        }
        boolean encrypt = EncryptionMain.matches(args, "-e", "--encrypt");
        boolean decrypt = EncryptionMain.matches(args, "-d", "--decrypt");
        if (!encrypt && !decrypt) {
            EncryptionMain.usage();
            System.exit(1);
        }
        String text = EncryptionMain.getText(args);
        if (encrypt) {
            System.out.println(Encryption.getDefaultEncryptor().encrypt(text));
        }
        if (decrypt) {
            System.out.println(Encryption.getDefaultEncryptor().decrypt(text));
        }
    }

    private static String getText(String[] args) {
        Optional<CanonicalFile> file = EncryptionMain.getFile(args);
        if (file.isPresent()) {
            try {
                return FileUtils.readFileToString((File)((File)file.get()));
            }
            catch (IOException e) {
                throw Exceptions.illegalState(e);
            }
        }
        return args[args.length - 1];
    }

    private static Optional<CanonicalFile> getFile(String[] args) {
        for (String arg : args) {
            if (!arg.startsWith("--file")) continue;
            List tokens = Splitter.on((char)'=').splitToList((CharSequence)arg);
            Preconditions.checkState((tokens.size() == 2 ? 1 : 0) != 0, (String)"expected 2 tokens from [%s], but got %s instead", (Object[])new Object[]{arg, tokens.size()});
            String filename = ((String)tokens.get(1)).replace(USER_HOME_TOKEN, USER_HOME_REPLACEMENT);
            return Optional.of((Object)new CanonicalFile(filename));
        }
        return Optional.absent();
    }

    private static boolean matches(String[] args, String option, String longoption) {
        for (String arg : args) {
            if (!arg.equals(option) && !arg.equals(longoption)) continue;
            return true;
        }
        return false;
    }

    private static void usage() {
        System.out.println("Usage: EncryptionMain --encrypt --decrypt [--file=filename] text");
    }
}

