/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.encrypt.openssl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.kuali.common.util.base.Precondition;

public final class OpenSSLEncryptedContext {
    private final ImmutableList<Byte> salt;
    private final ImmutableList<Byte> key;
    private final ImmutableList<Byte> initVector;

    private OpenSSLEncryptedContext(Builder builder) {
        this.salt = ImmutableList.copyOf((Collection)builder.salt);
        this.key = ImmutableList.copyOf((Collection)builder.key);
        this.initVector = ImmutableList.copyOf((Collection)builder.initVector);
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Byte> getSalt() {
        return this.salt;
    }

    public List<Byte> getKey() {
        return this.key;
    }

    public List<Byte> getInitVector() {
        return this.initVector;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<OpenSSLEncryptedContext> {
        private List<Byte> salt = Lists.newArrayList();
        private List<Byte> key = Lists.newArrayList();
        private List<Byte> initVector = Lists.newArrayList();

        public Builder withSalt(List<Byte> salt) {
            this.salt = salt;
            return this;
        }

        public Builder withKey(List<Byte> key) {
            this.key = key;
            return this;
        }

        public Builder withInitVector(List<Byte> initVector) {
            this.initVector = initVector;
            return this;
        }

        public OpenSSLEncryptedContext build() {
            return Builder.validate(new OpenSSLEncryptedContext(this));
        }

        private static OpenSSLEncryptedContext validate(OpenSSLEncryptedContext instance) {
            Precondition.checkNotNull(instance.salt, "salt");
            Precondition.checkNotNull(instance.key, "key");
            Precondition.checkNotNull(instance.initVector, "initVector");
            return instance;
        }
    }
}

