/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.encrypt.provider;

import com.google.common.base.Optional;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.base.Precondition;
import org.kuali.common.util.encrypt.EncryptionContext;
import org.kuali.common.util.encrypt.EncryptionStrength;
import org.kuali.common.util.encrypt.provider.EncryptionContextProvider;
import org.kuali.common.util.log.Loggers;
import org.slf4j.Logger;

public abstract class AbstractEncryptionContextProvider
implements EncryptionContextProvider {
    private static final Logger logger = Loggers.newLogger();
    private final String passwordKey;
    private final String strengthKey;

    public AbstractEncryptionContextProvider(String passwordKey, String strengthKey) {
        this.passwordKey = Precondition.checkNotBlank(passwordKey, "passwordKey");
        this.strengthKey = Precondition.checkNotBlank(strengthKey, "strengthKey");
    }

    @Override
    public Optional<EncryptionContext> getEncryptionContext() {
        Optional<String> password = this.getOptionalString(this.passwordKey);
        if (!password.isPresent()) {
            logger.debug(String.format("[%s, key=%s] encryption password not found", this.getClass().getSimpleName(), this.passwordKey));
            return Optional.absent();
        }
        EncryptionStrength strength = this.getEncryptionStrength();
        logger.debug(String.format("[%s, key=%s %s] encryption password located", new Object[]{this.getClass().getSimpleName(), this.passwordKey, strength}));
        return Optional.of((Object)new EncryptionContext((String)password.get(), strength));
    }

    protected Optional<String> getOptionalString(String key) {
        return Optional.fromNullable((Object)StringUtils.trimToNull((String)this.getValueFromSource(key)));
    }

    protected abstract String getValueFromSource(String var1);

    protected EncryptionStrength getEncryptionStrength() {
        Optional<String> optional = this.getOptionalString(this.strengthKey);
        if (optional.isPresent()) {
            return EncryptionStrength.valueOf(((String)optional.get()).toUpperCase());
        }
        return EncryptionStrength.DEFAULT_ENCRYPTION_STRENGTH;
    }
}

