/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.encrypt.provider;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.common.util.encrypt.EncryptionContext;
import org.kuali.common.util.encrypt.provider.EncryptionContextProvider;
import org.kuali.common.util.encrypt.provider.EnvironmentVariableEncryptionContextProvider;
import org.kuali.common.util.encrypt.provider.FileEncryptionContextProvider;
import org.kuali.common.util.encrypt.provider.MavenEncryptionContextProvider;
import org.kuali.common.util.encrypt.provider.SystemPropertiesEncryptionContextProvider;

public final class DefaultEncryptionContextProviderChain
implements EncryptionContextProvider {
    private static final String ENC_PASSWORD_KEY = "enc.password";
    private static final String ENC_STRENGTH_KEY = "enc.strength";
    private static final String ENC_MAVEN_ALTERNATE_PASSWORD_KEY = "enc.pwd";
    private final List<EncryptionContextProvider> providers;

    public DefaultEncryptionContextProviderChain() {
        ArrayList providers = Lists.newArrayList();
        providers.add(new SystemPropertiesEncryptionContextProvider(ENC_PASSWORD_KEY, ENC_STRENGTH_KEY));
        providers.add(new EnvironmentVariableEncryptionContextProvider(DefaultEncryptionContextProviderChain.toEnvKey(ENC_PASSWORD_KEY), DefaultEncryptionContextProviderChain.toEnvKey(ENC_STRENGTH_KEY)));
        providers.add(new FileEncryptionContextProvider());
        providers.add(new MavenEncryptionContextProvider(ENC_MAVEN_ALTERNATE_PASSWORD_KEY, ENC_STRENGTH_KEY));
        providers.add(new MavenEncryptionContextProvider(ENC_PASSWORD_KEY, ENC_STRENGTH_KEY));
        this.providers = ImmutableList.copyOf((Collection)providers);
    }

    public DefaultEncryptionContextProviderChain(EncryptionContextProvider ... providers) {
        this((List<EncryptionContextProvider>)ImmutableList.copyOf((Object[])providers));
    }

    public DefaultEncryptionContextProviderChain(List<EncryptionContextProvider> providers) {
        this.providers = ImmutableList.copyOf(providers);
    }

    public List<EncryptionContextProvider> getProviders() {
        return this.providers;
    }

    @Override
    public Optional<EncryptionContext> getEncryptionContext() {
        for (EncryptionContextProvider provider : this.providers) {
            Optional<EncryptionContext> context = provider.getEncryptionContext();
            if (!context.isPresent()) continue;
            return context;
        }
        return Optional.absent();
    }

    protected static String toEnvKey(String key) {
        return key.replace('.', '_').toUpperCase();
    }
}

