/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.encrypt.provider;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.base.Exceptions;
import org.kuali.common.util.encrypt.provider.AbstractEncryptionContextProvider;
import org.kuali.common.util.file.CanonicalFile;

public final class MavenEncryptionContextProvider
extends AbstractEncryptionContextProvider {
    private static final File USER_SETTINGS = MavenEncryptionContextProvider.getDefaultSettingsXmlFile();

    public MavenEncryptionContextProvider(String passwordKey, String strengthKey) {
        super(passwordKey, strengthKey);
    }

    @Override
    protected String getValueFromSource(String key) {
        if (!USER_SETTINGS.exists()) {
            return null;
        }
        String content = MavenEncryptionContextProvider.getContent(USER_SETTINGS);
        String open = "<" + key + ">";
        String close = "</" + key + ">";
        return StringUtils.substringBetween((String)content, (String)open, (String)close);
    }

    private static String getContent(File file) {
        try {
            return FileUtils.readFileToString((File)file);
        }
        catch (IOException e) {
            throw Exceptions.illegalState(e);
        }
    }

    private static File getDefaultSettingsXmlFile() {
        return new CanonicalFile(System.getProperty("user.home") + "/.m2/settings.xml");
    }
}

