/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.execute.Executable;
import org.springframework.util.Assert;

public class ConvertTableListingTextFileExecutable
implements Executable {
    private static String SQL = "sql";
    private static String METAINF = "META-INF";
    List<String> vendors = Arrays.asList("mysql", "oracle");
    String suffix = SQL;
    String prefix = SQL;
    String artifactId;
    File outputDir;
    boolean skip;

    @Override
    public void execute() {
        Assert.notNull((Object)this.artifactId, (String)"artifactId is null");
        Assert.notNull(this.vendors, (String)"vendors is null");
        Assert.notNull((Object)this.suffix, (String)"suffix is null");
        Assert.notNull((Object)this.prefix, (String)"prefix is null");
        Assert.notNull((Object)this.outputDir, (String)"outputDir is null");
        for (String vendor : this.vendors) {
            String tableListing = SQL + "/" + vendor + "/" + this.artifactId + "-tables.txt";
            List<String> tableNames = LocationUtils.readLines(tableListing);
            List<String> resources = this.getResources(tableNames, vendor, this.prefix, this.suffix);
            this.validateResources(resources);
            File outputFile = this.getOutputFile(this.outputDir, this.prefix, vendor, this.artifactId);
            this.writeLines(outputFile, resources);
        }
    }

    protected void validateResources(List<String> resources) {
        for (String resource : resources) {
            Assert.isTrue((boolean)LocationUtils.exists(resource), (String)("[" + resource + "] does not exist"));
        }
    }

    protected void writeLines(File file, List<String> lines) {
        try {
            FileUtils.writeLines((File)file, lines, (String)"\n");
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected File getOutputFile(File outputDir, String prefix, String vendor, String artifactId) {
        String filename = METAINF + "/" + prefix + "/" + vendor + "/" + artifactId + "-data.resources";
        return new File(outputDir, filename);
    }

    protected List<String> getResources(List<String> tableNames, String vendor, String prefix, String suffix) {
        ArrayList<String> resources = new ArrayList<String>();
        for (String tableName : tableNames) {
            String resource = "classpath:" + prefix + "/" + vendor + "/" + tableName + "." + suffix;
            resources.add(resource);
        }
        return resources;
    }

    public List<String> getVendors() {
        return this.vendors;
    }

    public void setVendors(List<String> vendors) {
        this.vendors = vendors;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

