/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute;

import java.util.List;
import java.util.Properties;
import org.kuali.common.util.Assert;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.execute.Executable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowPropertiesExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(ShowPropertiesExecutable.class);
    Properties properties;
    List<String> includes;
    List<String> excludes;

    @Override
    public void execute() {
        Assert.notNull((Object)this.properties, (String)"properties is null");
        Properties duplicate = PropertyUtils.duplicate(this.properties);
        PropertyUtils.trim(duplicate, this.includes, this.excludes);
        logger.info("Displaying {} properties\n\n{}", (Object)duplicate.size(), (Object)PropertyUtils.toString(duplicate));
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }
}

