/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute.impl;

import java.io.File;
import java.util.List;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.execute.impl.AbstractCopyLocationsExecutable;
import org.kuali.common.util.log.LoggerUtils;
import org.slf4j.Logger;

public final class CopyLocationsToDirectoryExecutable
extends AbstractCopyLocationsExecutable {
    private static final Logger logger = LoggerUtils.make();
    private final boolean addSequenceToFilenames;
    private final int initialSequenceNumber;

    public CopyLocationsToDirectoryExecutable(String locationListing, File directory) {
        this(locationListing, directory, true);
    }

    public CopyLocationsToDirectoryExecutable(String locationListing, File directory, boolean addSequenceToFilenames) {
        this(locationListing, directory, addSequenceToFilenames, 1);
    }

    public CopyLocationsToDirectoryExecutable(String locationListing, File directory, boolean addSequenceToFilenames, int initialSequenceNumber) {
        this(locationListing, directory, addSequenceToFilenames, initialSequenceNumber, false);
    }

    public CopyLocationsToDirectoryExecutable(String locationListing, File directory, boolean addSequenceToFilenames, int initialSequenceNumber, boolean skip) {
        super(locationListing, directory, skip);
        this.addSequenceToFilenames = addSequenceToFilenames;
        this.initialSequenceNumber = initialSequenceNumber;
    }

    @Override
    protected List<File> getFiles(List<String> locations) {
        List<String> filenames = LocationUtils.getFilenames(locations);
        if (this.addSequenceToFilenames) {
            logger.debug("Adding sequences");
            filenames = CollectionUtils.getSequencedStrings(filenames, this.initialSequenceNumber);
        }
        return LocationUtils.getFiles(this.getDirectory(), filenames);
    }

    public boolean isAddSequenceToFilenames() {
        return this.addSequenceToFilenames;
    }

    public int getInitialSequenceNumber() {
        return this.initialSequenceNumber;
    }
}

