/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute.impl;

import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import org.kuali.common.util.Assert;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.execute.Executable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutablesExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(ExecutablesExecutable.class);
    private final List<Executable> executables;
    private final boolean skip;
    private final boolean timed;

    public ExecutablesExecutable(Executable ... executables) {
        this((List<Executable>)ImmutableList.copyOf((Object[])executables));
    }

    public ExecutablesExecutable(List<Executable> executables) {
        this(executables, false);
    }

    public ExecutablesExecutable(List<Executable> executables, boolean skip) {
        this(executables, skip, false);
    }

    public ExecutablesExecutable(List<Executable> executables, boolean skip, boolean timed) {
        Assert.noNulls(executables);
        this.executables = ImmutableList.copyOf(executables);
        this.skip = skip;
        this.timed = timed;
    }

    @Override
    public void execute() {
        if (this.skip) {
            logger.info("Skipping execution of {} executables", (Object)this.executables.size());
            return;
        }
        long start = System.currentTimeMillis();
        for (Executable executable : this.executables) {
            executable.execute();
        }
        if (this.timed) {
            long stop = System.currentTimeMillis();
            logger.info("------------------------------------------------------------------------");
            logger.info("Total Time: {}", (Object)FormatUtils.getTime(stop - start));
            logger.info("Finished at: {}", (Object)new Date(stop));
            logger.info("------------------------------------------------------------------------");
        }
    }

    public List<Executable> getExecutables() {
        return this.executables;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public boolean isTimed() {
        return this.timed;
    }
}

