/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.filter;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kuali.common.util.Assert;
import org.kuali.common.util.filter.RegexUtils;

public final class StringFilter {
    private final List<String> includes;
    private final List<String> excludes;
    private final List<Pattern> includePatterns;
    private final List<Pattern> excludePatterns;

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public boolean include(String s) {
        if (this.isMatch(s, this.excludePatterns)) {
            return false;
        }
        return this.includePatterns.size() == 0 || this.isMatch(s, this.includePatterns);
    }

    private boolean isMatch(String s, List<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(s);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    private StringFilter(Builder builder) {
        this.includes = builder.includes;
        this.excludes = builder.excludes;
        this.includePatterns = builder.includePatterns;
        this.excludePatterns = builder.excludePatterns;
    }

    public static class Builder {
        private final List<String> includes;
        private final List<String> excludes;
        private final List<Pattern> includePatterns;
        private final List<Pattern> excludePatterns;

        public Builder() {
            this((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of());
        }

        public Builder(List<String> includes) {
            this(includes, (List<String>)ImmutableList.of());
        }

        public Builder(List<String> includes, List<String> excludes) {
            this.includes = ImmutableList.copyOf(includes);
            this.excludes = ImmutableList.copyOf(excludes);
            this.includePatterns = ImmutableList.copyOf(RegexUtils.getPatterns(includes));
            this.excludePatterns = ImmutableList.copyOf(RegexUtils.getPatterns(excludes));
        }

        private void validate(StringFilter filter) {
            Assert.noNulls(filter.includes, filter.excludes, filter.excludePatterns, filter.includePatterns);
        }

        public StringFilter build() {
            StringFilter filter = new StringFilter(this);
            this.validate(filter);
            return filter;
        }
    }
}

