/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.inform;

import org.kuali.common.util.Assert;
import org.kuali.common.util.inform.Inform;
import org.kuali.common.util.inform.StartStopInformer;

public final class PercentCompleteInformer {
    public static final int DEFAULT_PERCENTAGE_INCREMENT = 1;
    public static final long UNINITIALIZED_PROGRESS_INDICATOR = -1L;
    public static final int UNINITIALIZED_PERCENT_COMPLETE_INDICATOR = -1;
    private final int percentageIncrement;
    private final long total;
    private final Inform inform;
    private final StartStopInformer informer;
    private int percentComplete = -1;
    private volatile long progress = -1L;
    private boolean started = false;

    public PercentCompleteInformer(long total) {
        this(total, 1);
    }

    public PercentCompleteInformer(long total, int percentageIncrement) {
        this(total, 1, Inform.DEFAULT_INFORM);
    }

    public PercentCompleteInformer(long total, int percentageIncrement, Inform inform) {
        Assert.isTrue((total >= 0L ? 1 : 0) != 0, (String)"total is negative");
        Assert.isTrue((percentageIncrement > 0 ? 1 : 0) != 0, (String)"percentage increment must be greater than zero");
        Assert.noNulls(inform);
        this.total = total;
        this.inform = inform;
        this.percentageIncrement = percentageIncrement;
        this.informer = new StartStopInformer(inform);
    }

    public boolean isStarted() {
        return this.started;
    }

    public long getProgress() {
        return this.progress;
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    public synchronized void start() {
        Assert.isFalse(this.started, "Already started");
        this.started = true;
        this.percentComplete = 0;
        this.progress = 0L;
        this.informer.start();
    }

    public void incrementProgress() {
        this.incrementProgress(1L);
    }

    public synchronized void incrementProgress(long amount) {
        Assert.isTrue((boolean)this.started, (String)"Not started");
        this.progress += amount;
        int newPercentCompleted = (int)(this.progress * 100L / this.total);
        if (this.isEnoughProgress(newPercentCompleted, this.percentComplete, this.percentageIncrement)) {
            this.percentComplete = newPercentCompleted;
            this.inform.getPrintStream().print(this.inform.getProgressToken());
        }
    }

    public synchronized void stop() {
        Assert.isTrue((boolean)this.started, (String)"Not started");
        this.started = false;
        this.percentComplete = -1;
        this.progress = -1L;
        this.informer.stop();
    }

    protected boolean isEnoughProgress(int newPercentCompleted, int percentComplete, int percentageIncrement) {
        int needed = percentComplete + percentageIncrement;
        return newPercentCompleted >= needed;
    }

    public int getPercentageIncrement() {
        return this.percentageIncrement;
    }

    public long getTotal() {
        return this.total;
    }

    public Inform getInform() {
        return this.inform;
    }

    public StartStopInformer getInformer() {
        return this.informer;
    }
}

