/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.main.spring;

import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.main.MainContext;
import org.kuali.common.util.main.MainService;
import org.kuali.common.util.main.spring.MainConfig;
import org.kuali.common.util.main.spring.MainServiceConfig;
import org.kuali.common.util.properties.spring.DefaultPropertySourceConfig;
import org.kuali.common.util.spring.SpringExecUtils;
import org.kuali.common.util.spring.config.annotation.Execute;
import org.kuali.common.util.spring.service.PropertySourceConfig;
import org.kuali.common.util.spring.service.SpringService;
import org.kuali.common.util.spring.service.SpringServiceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.PropertySource;

@Configuration
@Import(value={SpringServiceConfig.class, MainServiceConfig.class})
public abstract class AbstractMainRunner
implements MainConfig {
    @Autowired
    MainContext mainContext;
    @Autowired
    MainService mainService;
    @Autowired
    SpringService service;

    protected Class<? extends PropertySourceConfig> getPropertySourceConfig() {
        return DefaultPropertySourceConfig.class;
    }

    protected abstract Class<?> getConfig();

    @Override
    @Execute
    public Executable main() {
        PropertySource<?> source = this.mainService.getPropertySource(this.mainContext, this.getPropertySourceConfig());
        return SpringExecUtils.getSpringExecutable(this.service, source, this.getConfig());
    }
}

