/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.maven.model;

import com.google.common.base.Optional;
import org.kuali.common.util.Assert;
import org.kuali.common.util.nullify.NullUtils;

public final class Dependency {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final Optional<String> classifier;
    private final String type;
    private final String scope;

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public Optional<String> getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    public String getScope() {
        return this.scope;
    }

    private Dependency(Builder builder) {
        this.groupId = builder.groupId;
        this.artifactId = builder.artifactId;
        this.version = builder.version;
        this.classifier = builder.classifier;
        this.type = builder.type;
        this.scope = builder.scope;
    }

    public static class Builder {
        public static final String DEFAULT_TYPE = "jar";
        public static final String DEFAULT_SCOPE = "compile";
        private final String groupId;
        private final String artifactId;
        private final String version;
        private Optional<String> classifier = Optional.absent();
        private String type = "jar";
        private String scope = "compile";

        public Builder(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public Builder classifier(String classifier) {
            this.classifier = Optional.fromNullable((Object)NullUtils.trimToNull(classifier));
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Dependency build() {
            Assert.noBlanks(this.groupId, this.artifactId, this.version, this.type, this.scope);
            Assert.noNulls(this.classifier);
            return new Dependency(this);
        }
    }
}

