/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.metainf.spring;

import org.kuali.common.util.Assert;
import org.kuali.common.util.metainf.spring.MetaInfGroup;

public class MetaInfConfigUtils {
    private static final String INCLUDES = "includes";
    private static final String EXCLUDES = "excludes";

    public static String getKey(String prefix, MetaInfGroup group, String suffix) {
        Assert.noNullsWithMsg("prefix and suffix are required", prefix, suffix);
        StringBuilder sb = new StringBuilder();
        sb.append("metainf");
        sb.append(".");
        sb.append(prefix);
        if (group != null) {
            sb.append(".");
            sb.append(group.name().toLowerCase());
        }
        sb.append(".");
        sb.append(suffix);
        return sb.toString();
    }

    public static String getIncludesKey(String prefix) {
        return MetaInfConfigUtils.getKey(prefix, null, INCLUDES);
    }

    public static String getExcludesKey(String prefix) {
        return MetaInfConfigUtils.getKey(prefix, null, EXCLUDES);
    }

    public static String getIncludesKey(MetaInfGroup group, String prefix) {
        return MetaInfConfigUtils.getKey(prefix, group, INCLUDES);
    }

    public static String getExcludesKey(MetaInfGroup group, String prefix) {
        return MetaInfConfigUtils.getKey(prefix, group, EXCLUDES);
    }
}

