/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.primitives;

public final class Numbers {
    private Numbers() {
    }

    public static boolean between(int number, int min, int max) {
        return number >= min && number <= max;
    }

    public static Number narrow(long number) {
        if (Numbers.isByte(number)) {
            return (byte)number;
        }
        if (Numbers.isShort(number)) {
            return (short)number;
        }
        if (Numbers.isInt(number)) {
            return (int)number;
        }
        return number;
    }

    public static boolean isByte(long number) {
        return number >= -128L && number <= 127L;
    }

    public static boolean isShort(long number) {
        return number >= -32768L && number <= 32767L;
    }

    public static boolean isInt(long number) {
        return number >= Integer.MIN_VALUE && number <= Integer.MAX_VALUE;
    }
}

