/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.properties;

import java.util.List;
import java.util.Properties;
import org.kuali.common.util.Assert;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.cache.Cache;
import org.kuali.common.util.cache.SimpleCache;
import org.kuali.common.util.properties.CachingLoader;
import org.kuali.common.util.properties.Location;
import org.kuali.common.util.properties.PropertiesLoader;
import org.kuali.common.util.properties.PropertiesService;
import org.kuali.common.util.property.processor.NoOpProcessor;
import org.kuali.common.util.property.processor.OverridingProcessor;
import org.kuali.common.util.property.processor.PropertyProcessor;
import org.kuali.common.util.resolver.PropertiesValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertiesService
implements PropertiesService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPropertiesService.class);
    private static final Cache<String, Properties> CACHE = new SimpleCache<String, Properties>();
    private static final PropertyProcessor DEFAULT_POST_PROCESSOR = NoOpProcessor.INSTANCE;
    private final Properties overrides;
    private final PropertyProcessor postProcessor;

    public DefaultPropertiesService(Properties overrides) {
        this(overrides, DEFAULT_POST_PROCESSOR);
    }

    public DefaultPropertiesService(Properties overrides, PropertyProcessor postProcessor) {
        Assert.noNulls(overrides, postProcessor);
        this.overrides = PropertyUtils.toImmutable(overrides);
        this.postProcessor = postProcessor;
    }

    protected PropertiesLoader getLoader(Location location, Cache<String, Properties> cache, Properties combined) {
        return new CachingLoader(location, CACHE);
    }

    @Override
    public Properties getProperties(List<Location> locations) {
        Properties properties = new Properties();
        for (Location location : locations) {
            Properties combined = PropertyUtils.combine(properties, this.overrides);
            PropertiesValueResolver resolver = new PropertiesValueResolver(combined);
            String resolvedLocation = resolver.resolve(location.getValue());
            Location actualLocation = this.getLocation(location, location.getValue(), resolvedLocation);
            PropertiesLoader loader = this.getLoader(actualLocation, CACHE, combined);
            Properties loaded = loader.load();
            new OverridingProcessor(loaded).process(properties);
        }
        this.postProcessor.process(properties);
        if (logger.isDebugEnabled()) {
            logger.debug("Displaying {} property values:\n\n{}", (Object)properties.size(), (Object)PropertyUtils.toString(properties));
        }
        return properties;
    }

    private Location getLocation(Location location, String originalLocation, String resolvedLocation) {
        if (originalLocation.equals(resolvedLocation)) {
            return location;
        }
        return Location.builder(location, resolvedLocation).build();
    }

    public void clearCache() {
        CACHE.clear();
    }

    public Properties getOverrides() {
        return this.overrides;
    }

    public PropertyProcessor getPostProcessor() {
        return this.postProcessor;
    }
}

