/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.properties;

import com.google.common.base.Preconditions;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Mode;
import org.kuali.common.util.property.PropertyFormat;

public final class Location {
    public static final Mode DEFAULT_MISSING_MODE = Mode.ERROR;
    public static final boolean DEFAULT_CACHEABLE = false;
    public static final PropertyFormat DEFAULT_PROPERTY_FORMAT = PropertyFormat.NORMAL;
    public static final String DEFAULT_ENCODING = Charset.defaultCharset().toString();
    private final Mode missingMode;
    private final String encoding;
    private final PropertyFormat format;
    private final String value;
    private final boolean cacheable;

    public Location(String value) {
        this(value, DEFAULT_ENCODING, DEFAULT_MISSING_MODE, DEFAULT_PROPERTY_FORMAT);
    }

    public Location(String value, String encoding) {
        this(value, encoding, DEFAULT_MISSING_MODE, DEFAULT_PROPERTY_FORMAT);
    }

    public Location(String value, String encoding, boolean cacheable) {
        this(value, encoding, DEFAULT_MISSING_MODE, DEFAULT_PROPERTY_FORMAT, cacheable);
    }

    public Location(String value, String encoding, Mode missingMode, PropertyFormat format) {
        this(value, encoding, DEFAULT_MISSING_MODE, DEFAULT_PROPERTY_FORMAT, false);
    }

    public Location(String value, String encoding, Mode missingMode, PropertyFormat format, boolean cacheable) {
        this.value = value;
        this.encoding = encoding;
        this.missingMode = missingMode;
        this.format = format;
        this.cacheable = cacheable;
        Builder.validate(this);
    }

    public Mode getMissingMode() {
        return this.missingMode;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public PropertyFormat getFormat() {
        return this.format;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    private Location(Builder builder) {
        this.missingMode = builder.missingMode;
        this.encoding = builder.encoding;
        this.format = builder.format;
        this.value = builder.value;
        this.cacheable = builder.cacheable;
    }

    public static Builder builder(String value) {
        return new Builder(value);
    }

    public static Builder builder(Location existing, String newValue) {
        return new Builder(newValue).cacheable(existing.isCacheable()).encoding(existing.getEncoding()).format(existing.getFormat()).missingMode(existing.getMissingMode());
    }

    public static class Builder {
        private final String value;
        private Mode missingMode = DEFAULT_MISSING_MODE;
        private String encoding = DEFAULT_ENCODING;
        private PropertyFormat format = DEFAULT_PROPERTY_FORMAT;
        private boolean cacheable = false;

        public Builder(String value) {
            this.value = value;
        }

        public Builder missingMode(Mode missingMode) {
            this.missingMode = missingMode;
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder format(PropertyFormat format) {
            this.format = format;
            return this;
        }

        public Builder cacheable(boolean cacheable) {
            this.cacheable = cacheable;
            return this;
        }

        public Location build() {
            Location instance = new Location(this);
            Builder.validate(instance);
            return instance;
        }

        private static void validate(Location instance) {
            Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)instance.value) ? 1 : 0) != 0, (Object)"value cannot be blank");
            Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)instance.encoding) ? 1 : 0) != 0, (Object)"encoding cannot be blank");
            Preconditions.checkNotNull((Object)((Object)instance.format), (Object)"format cannot be null");
            Preconditions.checkNotNull((Object)((Object)instance.missingMode), (Object)"missingMode cannot be null");
        }

        public Mode getMissingMode() {
            return this.missingMode;
        }

        public void setMissingMode(Mode missingMode) {
            this.missingMode = missingMode;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public PropertyFormat getFormat() {
            return this.format;
        }

        public void setFormat(PropertyFormat format) {
            this.format = format;
        }

        public boolean isCacheable() {
            return this.cacheable;
        }

        public void setCacheable(boolean cacheable) {
            this.cacheable = cacheable;
        }

        public String getValue() {
            return this.value;
        }
    }
}

