/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property.processor;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Properties;
import org.kuali.common.util.Assert;
import org.kuali.common.util.property.processor.PropertyProcessor;

public class ProcessorsProcessor
implements PropertyProcessor {
    private final List<PropertyProcessor> processors;

    public ProcessorsProcessor(PropertyProcessor ... processors) {
        this((List<PropertyProcessor>)ImmutableList.copyOf((Object[])processors));
    }

    public ProcessorsProcessor(List<PropertyProcessor> processors) {
        Assert.noNulls(processors);
        this.processors = ImmutableList.copyOf(processors);
    }

    @Override
    public void process(Properties properties) {
        for (PropertyProcessor processor : this.processors) {
            processor.process(properties);
        }
    }

    public List<PropertyProcessor> getProcessors() {
        return this.processors;
    }
}

