/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property.processor;

import java.io.File;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.OrgUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.log.Loggers;
import org.kuali.common.util.project.ProjectUtils;
import org.kuali.common.util.project.model.Project;
import org.kuali.common.util.property.processor.PropertyProcessor;
import org.slf4j.Logger;
import org.springframework.util.Assert;

public class ProjectProcessor
implements PropertyProcessor {
    private static final Logger logger = Loggers.newLogger();
    @Deprecated
    private static final String KS_GROUP_ID = "org.kuali.student";
    private static final String FS = File.separator;
    private static final String DOT = ".";
    private static final String PROJECT_GROUP_ID_PATH = "project.groupId.path";

    @Override
    public void process(Properties properties) {
        Assert.notNull((Object)properties, (String)"properties are null");
        this.validate(properties);
        this.fixKSGroupIds(properties);
        Project p = ProjectUtils.getProject(properties);
        String orgId = properties.getProperty("project.orgId");
        String orgCode = properties.getProperty("project.orgId.code");
        String groupCode = OrgUtils.getGroupCode(orgId, p.getGroupId());
        String userHome = System.getProperty("user.home");
        String orgHome = userHome + FS + DOT + orgCode;
        String groupHome = orgHome + FS + groupCode;
        properties.setProperty(PROJECT_GROUP_ID_PATH, Str.getPath(p.getGroupId()));
        properties.setProperty("project.orgId.home", orgHome);
        properties.setProperty("project.groupId.home", groupHome);
        properties.setProperty("project.home", groupHome);
        properties.setProperty("project.groupId.code", groupCode);
        properties.setProperty("project.build.timestamp.millis", Long.toString(System.currentTimeMillis()));
    }

    protected void validate(Properties properties) {
        Assert.notNull((Object)properties.getProperty("project.groupId"), (String)"project.groupId is null");
        Assert.notNull((Object)properties.getProperty("project.artifactId"), (String)"project.artifactId is null");
        Assert.notNull((Object)properties.getProperty("project.orgId"), (String)"project.orgId is null");
        Assert.notNull((Object)properties.getProperty("project.orgId.code"), (String)"project.orgId.code is null");
    }

    @Deprecated
    protected void fixKSGroupIds(Properties properties) {
        String groupId = properties.getProperty("project.groupId");
        if (!StringUtils.startsWith((CharSequence)groupId, (CharSequence)KS_GROUP_ID)) {
            return;
        }
        properties.setProperty("project.groupId", KS_GROUP_ID);
        if (!StringUtils.equals((CharSequence)groupId, (CharSequence)KS_GROUP_ID)) {
            logger.debug("original={}", (Object)groupId);
            properties.setProperty("project.groupId.original", groupId);
        }
    }
}

