/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property.processor;

import java.util.Properties;
import org.kuali.common.util.Assert;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.property.processor.PropertyProcessor;

public class RevealProcessor
implements PropertyProcessor {
    public static final String DEFAULT_REVEAL_KEY = "properties.reveal";
    private final String revealKey;

    public RevealProcessor() {
        this(DEFAULT_REVEAL_KEY);
    }

    public RevealProcessor(String revealKey) {
        Assert.noBlanks(revealKey);
        this.revealKey = revealKey;
    }

    @Override
    public void process(Properties properties) {
        boolean reveal = PropertyUtils.getBoolean(this.revealKey, properties, true);
        if (reveal) {
            PropertyUtils.reveal(properties);
        }
    }

    public String getRevealKey() {
        return this.revealKey;
    }
}

