/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.common.util.Assert;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.property.ProjectProperties;
import org.kuali.common.util.property.ProjectPropertiesComparator;
import org.kuali.common.util.property.PropertiesContext;
import org.kuali.common.util.spring.SpringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.CollectionUtils;

@Deprecated
public class ProjectPropertiesLoaderFactoryBean
implements FactoryBean<Properties> {
    private static final Logger logger = LoggerFactory.getLogger(ProjectPropertiesLoaderFactoryBean.class);
    List<String> locations;
    boolean singleton = true;
    ProjectPropertiesComparator comparator;

    public Properties getObject() {
        Assert.isFalse(CollectionUtils.isEmpty(this.locations), "locations is empty");
        long start = System.currentTimeMillis();
        ArrayList pps = new ArrayList();
        for (String location : this.locations) {
            Map<String, ProjectProperties> beans = SpringUtils.getAllBeans(location, ProjectProperties.class);
            logger.info("Located {} sets of project properties", (Object)beans.size());
            ArrayList<ProjectProperties> list = new ArrayList<ProjectProperties>();
            for (ProjectProperties bean : beans.values()) {
                list.add(bean);
            }
            pps.addAll(list);
        }
        Properties properties = new Properties();
        for (ProjectProperties pp : pps) {
            PropertiesContext ctx = pp.getPropertiesContext();
            Properties combined = PropertyUtils.combine(properties, ctx.getProperties());
            ctx.setProperties(combined);
            Properties loaded = PropertyUtils.load(ctx);
            properties.putAll((Map<?, ?>)loaded);
        }
        String elapsed = FormatUtils.getTime(System.currentTimeMillis() - start);
        logger.info("Loaded {} properties.  Total time: {}", (Object)properties.size(), (Object)elapsed);
        return properties;
    }

    public Class<Properties> getObjectType() {
        return Properties.class;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public ProjectPropertiesComparator getComparator() {
        return this.comparator;
    }

    public void setComparator(ProjectPropertiesComparator comparator) {
        this.comparator = comparator;
    }
}

