/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.common.util.Assert;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.log.LoggerUtils;
import org.kuali.common.util.properties.Location;
import org.kuali.common.util.properties.PropertiesService;
import org.kuali.common.util.property.ImmutableProperties;
import org.kuali.common.util.spring.PropertySourceNameComparator;
import org.kuali.common.util.spring.SpringUtils;
import org.kuali.common.util.spring.service.PropertySourceContext;
import org.kuali.common.util.spring.service.SpringContext;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class PropertySourceUtils {
    private static final String PROPERTIES_PROPERTY_SOURCE = "propertiesPropertySource";
    private static final Logger logger = LoggerUtils.make();

    public static PropertySource<?> getDefaultPropertySource() {
        return new PropertiesPropertySource(PROPERTIES_PROPERTY_SOURCE, PropertyUtils.getGlobalProperties());
    }

    public static PropertySource<?> getPropertySource(Properties properties) {
        return new PropertiesPropertySource(PROPERTIES_PROPERTY_SOURCE, PropertyUtils.getGlobalProperties(properties));
    }

    public static PropertySource<?> getPropertySource(PropertiesService service, List<Location> locations) {
        return PropertySourceUtils.getPropertySource(service, locations, false);
    }

    public static PropertySource<?> getPropertySource(PropertiesService service, List<Location> locations, boolean includeGlobal) {
        Properties properties = service.getProperties(locations);
        if (includeGlobal) {
            properties = PropertyUtils.getGlobalProperties(properties);
        }
        return new PropertiesPropertySource(PROPERTIES_PROPERTY_SOURCE, properties);
    }

    public static Properties getAllEnumerableProperties(ConfigurableEnvironment env) {
        List<PropertySource<?>> sources = PropertySourceUtils.getPropertySources(env);
        Collections.reverse(sources);
        List<EnumerablePropertySource<?>> enumerables = PropertySourceUtils.asEnumerableList(sources);
        return PropertySourceUtils.convert(enumerables);
    }

    public static Properties getAllEnumerablePropertiesQuietly(ConfigurableEnvironment env) {
        List<PropertySource<?>> sources = PropertySourceUtils.getPropertySources(env);
        Collections.reverse(sources);
        List<EnumerablePropertySource<?>> enumerables = PropertySourceUtils.asEnumerableListQuietly(sources);
        return PropertySourceUtils.convert(enumerables);
    }

    public static ImmutableProperties getEnvAsImmutableProperties(ConfigurableEnvironment env) {
        return new ImmutableProperties(PropertySourceUtils.getAllEnumerableProperties(env));
    }

    public static List<EnumerablePropertySource<?>> asEnumerableList(List<PropertySource<?>> sources) {
        ArrayList list = new ArrayList();
        for (PropertySource<?> source : sources) {
            boolean expression = source instanceof EnumerablePropertySource;
            String errorMessage = "'%s' is not enumerable [%s]";
            Object[] args = new Object[]{source.getName(), source.getClass().getCanonicalName()};
            Preconditions.checkState((boolean)expression, (String)errorMessage, (Object[])args);
            EnumerablePropertySource element = (EnumerablePropertySource)source;
            list.add(element);
        }
        return list;
    }

    public static List<EnumerablePropertySource<?>> asEnumerableListQuietly(List<PropertySource<?>> sources) {
        ArrayList list = new ArrayList();
        for (PropertySource<?> source : sources) {
            if (source instanceof EnumerablePropertySource) {
                EnumerablePropertySource element = (EnumerablePropertySource)source;
                list.add(element);
                continue;
            }
            logger.warn("'{}' is not enumerable [{}]", (Object)source.getName(), (Object)source.getClass().getCanonicalName());
        }
        return list;
    }

    public static List<PropertySource<?>> getPropertySources(Class<?> annotatedClass) {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{annotatedClass});
        return PropertySourceUtils.extractPropertySourcesAndClose((ConfigurableApplicationContext)context);
    }

    public static List<PropertySource<?>> extractPropertySourcesAndClose(ConfigurableApplicationContext context) {
        List<PropertySource<?>> sources = PropertySourceUtils.getPropertySources(context);
        SpringUtils.closeQuietly(context);
        return sources;
    }

    public static Properties convert(EnumerablePropertySource<?> source) {
        String[] names;
        Assert.notNull(source, (String)"source is null");
        Properties properties = new Properties();
        for (String name : names = source.getPropertyNames()) {
            Object object = source.getProperty(name);
            Assert.notNull((Object)object, (String)("[" + name + "] is null"));
            Assert.isTrue((boolean)(object instanceof String), (String)("[" + name + "] is not a string"));
            properties.setProperty(name, (String)object);
        }
        return properties;
    }

    public static Properties convert(List<EnumerablePropertySource<?>> sources) {
        Properties converted = new Properties();
        for (EnumerablePropertySource<?> source : sources) {
            Properties properties = PropertySourceUtils.convert(source);
            converted.putAll((Map<?, ?>)properties);
        }
        return converted;
    }

    public static List<PropertySource<?>> getPropertySources(ConfigurableEnvironment env) {
        Preconditions.checkNotNull((Object)env, (Object)"'env' cannot be null");
        MutablePropertySources mps = env.getPropertySources();
        ArrayList sources = new ArrayList();
        for (PropertySource source : mps) {
            sources.add(source);
        }
        return sources;
    }

    public static void reconfigurePropertySources(ConfigurableEnvironment env, String name, Properties properties) {
        PropertySourceUtils.removeAllPropertySources(env);
        MutablePropertySources mps = env.getPropertySources();
        Assert.isTrue((mps.size() == 0 ? 1 : 0) != 0);
        PropertiesPropertySource pps = new PropertiesPropertySource(name, properties);
        mps.addFirst((PropertySource)pps);
    }

    public static void removeAllPropertySources(ConfigurableEnvironment env) {
        MutablePropertySources mps = env.getPropertySources();
        List<PropertySource<?>> sources = PropertySourceUtils.getPropertySources(env);
        for (PropertySource<?> source : sources) {
            String name = source.getName();
            mps.remove(name);
        }
    }

    public static List<PropertySource<?>> asList(PropertySource<?> ... sources) {
        ArrayList list = new ArrayList();
        if (sources == null) {
            return list;
        }
        for (PropertySource<?> element : sources) {
            if (element == null) continue;
            list.add(element);
        }
        return list;
    }

    public static List<PropertySource<?>> getPropertySources(ConfigurableApplicationContext context, Comparator<PropertySource<?>> comparator) {
        Map map = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, PropertySource.class);
        ArrayList list = new ArrayList();
        for (PropertySource source : map.values()) {
            list.add(source);
        }
        Collections.sort(list, comparator);
        return list;
    }

    public static List<PropertySource<?>> getPropertySources(ConfigurableApplicationContext context) {
        return PropertySourceUtils.getPropertySources(context, new PropertySourceNameComparator());
    }

    public static SpringContext getSinglePropertySourceContext(PropertySource<?> source) {
        PropertySourceContext psc = new PropertySourceContext(source, true);
        SpringContext context = new SpringContext();
        context.setPropertySourceContext(psc);
        return context;
    }
}

