/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring;

import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.spring.service.DefaultSpringService;
import org.kuali.common.util.spring.service.SpringContext;
import org.kuali.common.util.spring.service.SpringService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(SpringExecutable.class);
    public static final SpringService DEFAULT_SPRING_SERVICE = new DefaultSpringService();
    SpringService service = DEFAULT_SPRING_SERVICE;
    SpringContext context;
    boolean skip;

    public SpringExecutable() {
        this(null);
    }

    public SpringExecutable(SpringContext context) {
        this(DEFAULT_SPRING_SERVICE, context);
    }

    public SpringExecutable(SpringService service, SpringContext context) {
        this.service = service;
        this.context = context;
    }

    @Override
    public void execute() {
        if (this.skip) {
            logger.info("Skipping execution");
        } else {
            this.service.load(this.context);
        }
    }

    public SpringService getService() {
        return this.service;
    }

    public void setService(SpringService service) {
        this.service = service;
    }

    public SpringContext getContext() {
        return this.context;
    }

    public void setContext(SpringContext context) {
        this.context = context;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

