/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring.env;

import com.google.common.base.Optional;
import java.util.Properties;
import org.kuali.common.util.Ascii;
import org.kuali.common.util.Assert;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.kuali.common.util.spring.env.PropertiesEnvironment;
import org.springframework.core.env.Environment;

public class EnvUtils {
    public static final Optional<EnvironmentService> ABSENT = Optional.absent();
    private static final String ENV_PREFIX = "env";
    private static Environment instance;

    public static long getBytes(EnvironmentService env, String key, long provided) {
        if (env.containsProperty(key)) {
            String size = env.getString(key);
            long bytes = FormatUtils.getBytes(size);
            return bytes;
        }
        return provided;
    }

    public static synchronized Environment getDefaultEnvironment() {
        if (instance == null) {
            Properties global = PropertyUtils.getGlobalProperties();
            instance = new PropertiesEnvironment(global);
        }
        return instance;
    }

    public static String getEnvironmentVariableKey(String key) {
        Assert.noBlanks(key);
        return "env." + EnvUtils.toUnderscore(key).toUpperCase();
    }

    public static String toUnderscore(String key) {
        char[] chars = key.toCharArray();
        StringBuilder sb = new StringBuilder();
        char prevChar = '\u0000';
        for (char c : chars) {
            if (c == '.') {
                sb.append('_');
            } else if (Ascii.isUpperCase(c) && Ascii.isLowerCase(prevChar)) {
                sb.append('_');
                sb.append(c);
            } else {
                sb.append(c);
            }
            prevChar = c;
        }
        return sb.toString();
    }
}

