/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring.event;

import com.google.common.base.Preconditions;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.log.LoggerUtils;
import org.slf4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;

public final class ExecutableApplicationEventListener<T extends ApplicationEvent>
implements SmartApplicationListener {
    private static final Logger logger = LoggerUtils.make();
    private final Executable executable;
    private final int order;
    private final Class<T> supportedEventType;

    public void onApplicationEvent(ApplicationEvent event) {
        this.checkEvent(event);
        logger.info("Received event: [{}]", (Object)event.getClass().getCanonicalName());
        this.executable.execute();
    }

    public int getOrder() {
        return this.order;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return this.supportedEventType == eventType;
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    private void checkEvent(ApplicationEvent event) {
        boolean expression = this.supportedEventType == event.getClass();
        String errorMessage = "[%s] is the only supported event type.  Events of type [%s] should not be getting passed to this listener";
        Object[] args = new Object[]{this.supportedEventType.getCanonicalName(), event.getClass().getCanonicalName()};
        Preconditions.checkArgument((boolean)expression, (String)errorMessage, (Object[])args);
    }

    private ExecutableApplicationEventListener(Builder<T> builder) {
        this.executable = ((Builder)builder).executable;
        this.order = ((Builder)builder).order;
        this.supportedEventType = ((Builder)builder).supportedEventType;
    }

    public static <T extends ApplicationEvent> Builder<T> builder(Executable executable, Class<T> supportedEventType) {
        return new Builder<T>(executable, supportedEventType);
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public Class<T> getSupportedEventType() {
        return this.supportedEventType;
    }

    public static class Builder<T extends ApplicationEvent> {
        private final Executable executable;
        private final Class<T> supportedEventType;
        private int order = 0;

        public Builder(Executable executable, Class<T> supportedEventType) {
            this.executable = executable;
            this.supportedEventType = supportedEventType;
        }

        public ExecutableApplicationEventListener<T> build() {
            ExecutableApplicationEventListener instance = new ExecutableApplicationEventListener(this);
            this.validate(instance);
            return instance;
        }

        private void validate(ExecutableApplicationEventListener<T> instance) {
            Preconditions.checkNotNull((Object)instance.getExecutable(), (Object)"'executable' cannot be null");
            Preconditions.checkNotNull(instance.getSupportedEventType(), (Object)"'supportedEventType' cannot be null");
        }

        public Builder<T> order(int order) {
            this.order = order;
            return this;
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public Executable getExecutable() {
            return this.executable;
        }
    }
}

