/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring.service;

import org.kuali.common.util.spring.env.BasicEnvironmentService;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.kuali.common.util.spring.env.model.EnvironmentServiceContext;
import org.kuali.common.util.spring.service.DefaultPropertySourceService;
import org.kuali.common.util.spring.service.DefaultSpringService;
import org.kuali.common.util.spring.service.PropertySourceService;
import org.kuali.common.util.spring.service.SpringService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class SpringServiceConfig {
    @Autowired
    Environment env;

    @Bean
    public SpringService springService() {
        return new DefaultSpringService();
    }

    @Bean
    public PropertySourceService propertySourceService() {
        return new DefaultPropertySourceService(this.springService());
    }

    @Bean
    public EnvironmentService environmentService() {
        EnvironmentServiceContext context = new EnvironmentServiceContext.Builder().env(this.env).build();
        return new BasicEnvironmentService(context);
    }
}

