/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.stream;

import org.codehaus.plexus.util.cli.StreamConsumer;
import org.kuali.common.util.base.Precondition;
import org.kuali.common.util.log.LoggerLevel;
import org.kuali.common.util.log.LoggerUtils;
import org.slf4j.Logger;

public final class LoggingStreamConsumer
implements StreamConsumer {
    private final Logger logger;
    private final LoggerLevel level;

    public LoggingStreamConsumer(Logger logger) {
        this(logger, LoggerLevel.INFO);
    }

    public LoggingStreamConsumer(Logger logger, LoggerLevel level) {
        this.logger = Precondition.checkNotNull(logger, "logger");
        this.level = Precondition.checkNotNull(level, "level");
    }

    public void consumeLine(String line) {
        LoggerUtils.logMsg(line, this.logger, this.level);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LoggerLevel getLevel() {
        return this.level;
    }
}

