/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.stream;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.util.cli.StreamConsumer;

public final class StringStreamConsumer
implements StreamConsumer {
    private static final String LS = System.getProperty("line.separator");
    private final List<String> lines = Collections.synchronizedList(new ArrayList());

    public void consumeLine(String line) {
        this.lines.add(line);
    }

    public synchronized Optional<String> getOutput() {
        if (this.lines.size() > 0) {
            return Optional.of((Object)Joiner.on((String)LS).join(this.lines));
        }
        return Optional.absent();
    }

    public synchronized List<String> getLines() {
        return ImmutableList.copyOf(this.lines);
    }
}

