/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.sync;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kuali.common.util.Assert;
import org.kuali.common.util.FileSystemUtils;
import org.kuali.common.util.SyncRequest;
import org.kuali.common.util.SyncResult;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.scm.ScmService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncFilesExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(SyncFilesExecutable.class);
    boolean skip;
    boolean commitChanges;
    ScmService service;
    String message = "Automated update";
    List<SyncRequest> requests;
    List<File> commitPaths;

    @Override
    public void execute() {
        if (this.skip) {
            logger.info("Skipping file sync");
            return;
        }
        Assert.notNull(this.requests);
        Assert.notNull((Object)this.service);
        Assert.notNull(this.commitPaths);
        ArrayList<File> adds = new ArrayList<File>();
        ArrayList<File> deletes = new ArrayList<File>();
        List<SyncResult> results = this.syncFiles();
        for (SyncResult result : results) {
            adds.addAll(result.getAdds());
            deletes.addAll(result.getDeletes());
        }
        logger.info("---------- Sync results ----------");
        logger.info("Files added - {}", (Object)adds.size());
        logger.info("Files deleted - {}", (Object)deletes.size());
        logger.info("---------- Sync results ----------");
        if (this.commitChanges) {
            this.service.add(adds);
            this.service.delete(deletes);
            this.service.commit(this.commitPaths, this.message);
        } else {
            logger.info("Skipping SCM commit");
        }
    }

    public List<SyncResult> syncFiles() {
        logger.info("Syncing {} requests", (Object)this.requests.size());
        try {
            return FileSystemUtils.syncFiles(this.requests);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error", e);
        }
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public ScmService getService() {
        return this.service;
    }

    public void setService(ScmService service) {
        this.service = service;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isCommitChanges() {
        return this.commitChanges;
    }

    public void setCommitChanges(boolean commitChanges) {
        this.commitChanges = commitChanges;
    }

    public List<File> getCommitPaths() {
        return this.commitPaths;
    }

    public void setCommitPaths(List<File> commitPaths) {
        this.commitPaths = commitPaths;
    }

    public List<SyncRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(List<SyncRequest> requests) {
        this.requests = requests;
    }
}

