/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.tree;

import com.google.common.base.Preconditions;
import java.util.List;
import org.kuali.common.util.tree.MutableNode;
import org.kuali.common.util.tree.Node;

public final class ImmutableNode<T>
extends MutableNode<T> {
    private static final String UOE_MSG = "not supported for immutable node's";

    public static <T> ImmutableNode<T> copyOf(Node<T> node) {
        if (node instanceof ImmutableNode) {
            return (ImmutableNode)node;
        }
        return new ImmutableNode<T>(node);
    }

    public ImmutableNode(Node<T> node) {
        Preconditions.checkNotNull(node);
        super.setElement(node.getElement());
        List<Node<T>> children = node.getChildren();
        for (Node<T> child : children) {
            super.add(children.size(), ImmutableNode.copyOf(child));
        }
    }

    @Override
    public void setElement(T element) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    public void add(List<MutableNode<T>> children) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    public void add(MutableNode<T> child1, MutableNode<T> child2) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    public void add(MutableNode<T> child1, MutableNode<T> child2, MutableNode<T> child3) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    public void add(MutableNode<T> child1, MutableNode<T> child2, MutableNode<T> child3, MutableNode<T> child4) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    public void add(MutableNode<T> child1, MutableNode<T> child2, MutableNode<T> child3, MutableNode<T> child4, MutableNode<T> child5) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    public void add(MutableNode<T> child) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    public void add(int index, MutableNode<T> child) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    public void remove(MutableNode<T> child) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    public void remove(int index) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    public void removeAllChildren() {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    public void removeFromParent() {
        throw new UnsupportedOperationException(UOE_MSG);
    }
}

