/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.wait;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.base.Threads;
import org.kuali.common.util.condition.Condition;
import org.kuali.common.util.log.Loggers;
import org.kuali.common.util.wait.WaitContext;
import org.kuali.common.util.wait.WaitResult;
import org.kuali.common.util.wait.WaitService;
import org.slf4j.Logger;

public class DefaultWaitService
implements WaitService {
    private static final Logger logger = Loggers.newLogger();

    @Override
    public WaitResult wait(WaitContext context, Condition condition) {
        long start = System.currentTimeMillis();
        long timeout = start + context.getTimeoutMillis();
        Threads.sleep(context.getInitialPauseMillis());
        while (!condition.isTrue()) {
            long now = System.currentTimeMillis();
            Preconditions.checkState((now <= timeout ? 1 : 0) != 0, (Object)"Timed out waiting");
            String elapsed = StringUtils.leftPad((String)FormatUtils.getTime(now - start), (int)7, (String)" ");
            String timeoutString = StringUtils.leftPad((String)FormatUtils.getTime(timeout - now), (int)7, (String)" ");
            logger.info("[elapsed: {}  timeout: {}]", (Object)elapsed, (Object)timeoutString);
            Threads.sleep(context.getSleepMillis());
        }
        return WaitResult.create(start, System.currentTimeMillis());
    }
}

