/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.xml.jaxb.adapter;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.kuali.common.util.xml.jaxb.wrapper.ListWrapper;

public class ImmutableListAdapter<T>
extends XmlAdapter<ListWrapper<T>, List<T>> {
    private final List<T> EMPTY_LIST = Collections.emptyList();
    private final ListWrapper<T> EMPTY_WRAPPER = new ListWrapper<T>(this.EMPTY_LIST);

    public ListWrapper<T> marshal(List<T> list) {
        if (ImmutableListAdapter.isEmpty(list)) {
            return this.EMPTY_WRAPPER;
        }
        return new ListWrapper<T>(list);
    }

    public List<T> unmarshal(ListWrapper<T> wrapper) {
        if (ImmutableListAdapter.isEmpty(wrapper.getList())) {
            return this.EMPTY_LIST;
        }
        return ImmutableList.copyOf(wrapper.getList());
    }

    protected static boolean isEmpty(List<?> list) {
        return list == null || list.size() == 0;
    }
}

