/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.inversion;

import org.la4j.Matrix;
import org.la4j.inversion.MatrixInverter;

public class NoPivotGaussInverter
implements MatrixInverter {
    private final Matrix matrix;

    public NoPivotGaussInverter(Matrix matrix) {
        this.matrix = matrix;
    }

    @Override
    public Matrix inverse() {
        if (this.matrix.rows() != this.matrix.columns()) {
            throw new IllegalArgumentException("Wrong matrix size: rows != columns");
        }
        Matrix result = this.matrix.copy();
        for (int k = 0; k < this.matrix.rows(); ++k) {
            double diagonalTerm = result.get(k, k);
            if (Math.abs(diagonalTerm) <= Double.MIN_VALUE) {
                throw new IllegalArgumentException("This matrix cannot be inverted with a non-pivoting Gauss elimination method.");
            }
            double var = 1.0 / result.get(k, k);
            result.set(k, k, 1.0);
            for (int j = 0; j < this.matrix.rows(); ++j) {
                result.set(k, j, result.get(k, j) * var);
            }
            for (int i = 0; i < this.matrix.rows(); ++i) {
                if (i == k) continue;
                var = result.get(i, k);
                result.set(i, k, 0.0);
                for (int j = 0; j < this.matrix.rows(); ++j) {
                    result.set(i, j, result.get(i, j) - var * result.get(k, j));
                }
            }
        }
        return result;
    }

    @Override
    public Matrix self() {
        return this.matrix;
    }
}

