/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.matrix;

import java.text.NumberFormat;
import java.util.Random;
import org.la4j.Matrices;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.Vectors;
import org.la4j.iterator.ColumnMajorMatrixIterator;
import org.la4j.iterator.MatrixIterator;
import org.la4j.iterator.RowMajorMatrixIterator;
import org.la4j.iterator.VectorIterator;
import org.la4j.matrix.DenseMatrix;
import org.la4j.matrix.functor.MatrixAccumulator;
import org.la4j.matrix.functor.MatrixProcedure;
import org.la4j.matrix.sparse.CCSMatrix;
import org.la4j.matrix.sparse.CRSMatrix;
import org.la4j.vector.SparseVector;
import org.la4j.vector.functor.VectorAccumulator;
import org.la4j.vector.functor.VectorProcedure;

public abstract class SparseMatrix
extends Matrix {
    protected int cardinality;

    public static SparseMatrix zero(int rows, int columns) {
        return CCSMatrix.zero(rows, columns);
    }

    public static SparseMatrix zero(int rows, int columns, int capacity) {
        return CRSMatrix.zero(rows, columns, capacity);
    }

    public static SparseMatrix diagonal(int size, double diagonal) {
        return CRSMatrix.diagonal(size, diagonal);
    }

    public static SparseMatrix identity(int size) {
        return CRSMatrix.identity(size);
    }

    public static SparseMatrix random(int rows, int columns, double density, Random random) {
        return CRSMatrix.random(rows, columns, density, random);
    }

    public static SparseMatrix randomSymmetric(int size, double density, Random random) {
        return CRSMatrix.randomSymmetric(size, density, random);
    }

    public static SparseMatrix from1DArray(int rows, int columns, double[] array) {
        return CRSMatrix.from1DArray(rows, columns, array);
    }

    public static SparseMatrix from2DArray(double[][] array) {
        return CRSMatrix.from2DArray(array);
    }

    public static SparseMatrix block(Matrix a, Matrix b, Matrix c, Matrix d) {
        return CRSMatrix.block(a, b, c, d);
    }

    public static SparseMatrix fromCSV(String csv) {
        return Matrix.fromCSV(csv).to(Matrices.SPARSE);
    }

    public static SparseMatrix fromMatrixMarket(String mm) {
        return Matrix.fromMatrixMarket(mm).to(Matrices.SPARSE);
    }

    public SparseMatrix(int rows, int columns) {
        this(rows, columns, 0);
    }

    public SparseMatrix(int rows, int columns, int cardinality) {
        super(rows, columns);
        this.cardinality = cardinality;
    }

    @Override
    public double get(int i, int j) {
        return this.getOrElse(i, j, 0.0);
    }

    public abstract double getOrElse(int var1, int var2, double var3);

    public abstract boolean isRowMajor();

    public boolean isColumnMajor() {
        return !this.isRowMajor();
    }

    public int cardinality() {
        return this.cardinality;
    }

    public double density() {
        return (double)this.cardinality / (double)(this.rows * this.columns);
    }

    protected long capacity() {
        return (long)this.rows * (long)this.columns;
    }

    @Override
    public Vector getRow(int i) {
        SparseVector result = SparseVector.zero(this.columns);
        VectorIterator it = this.nonZeroIteratorOfRow(i);
        while (it.hasNext()) {
            double x = (Double)it.next();
            int j = it.index();
            result.set(j, x);
        }
        return result;
    }

    @Override
    public Vector getColumn(int j) {
        SparseVector result = SparseVector.zero(this.rows);
        VectorIterator it = this.nonZeroIteratorOfColumn(j);
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            result.set(i, x);
        }
        return result;
    }

    @Override
    public Matrix multiply(double value) {
        MatrixIterator it = this.nonZeroIterator();
        Matrix result = this.blank();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            result.set(i, j, x * value);
        }
        return result;
    }

    @Override
    public Matrix add(double value) {
        MatrixIterator it = this.nonZeroIterator();
        DenseMatrix result = DenseMatrix.constant(this.rows, this.columns, value);
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            result.set(i, j, x + value);
        }
        return result;
    }

    public boolean isZeroAt(int i, int j) {
        return !this.nonZeroAt(i, j);
    }

    public abstract boolean nonZeroAt(int var1, int var2);

    public void eachNonZero(MatrixProcedure procedure) {
        MatrixIterator it = this.nonZeroIterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            procedure.apply(i, j, x);
        }
    }

    public void eachNonZeroInRow(int i, VectorProcedure procedure) {
        VectorIterator it = this.nonZeroIteratorOfRow(i);
        while (it.hasNext()) {
            double x = (Double)it.next();
            int j = it.index();
            procedure.apply(j, x);
        }
    }

    public void eachNonZeroInColumn(int j, VectorProcedure procedure) {
        VectorIterator it = this.nonZeroIteratorOfColumn(j);
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            procedure.apply(i, x);
        }
    }

    public double foldNonZero(MatrixAccumulator accumulator) {
        this.eachNonZero(Matrices.asAccumulatorProcedure(accumulator));
        return accumulator.accumulate();
    }

    public double foldNonZeroInRow(int i, VectorAccumulator accumulator) {
        this.eachNonZeroInRow(i, Vectors.asAccumulatorProcedure(accumulator));
        return accumulator.accumulate();
    }

    public double foldNonZeroInColumn(int j, VectorAccumulator accumulator) {
        this.eachNonZeroInColumn(j, Vectors.asAccumulatorProcedure(accumulator));
        return accumulator.accumulate();
    }

    public double[] foldNonZeroInColumns(VectorAccumulator accumulator) {
        double[] result = new double[this.columns];
        for (int j = 0; j < this.columns; ++j) {
            result[j] = this.foldNonZeroInColumn(j, accumulator);
        }
        return result;
    }

    public double[] foldNonZeroInRows(VectorAccumulator accumulator) {
        double[] result = new double[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            result[i] = this.foldNonZeroInRow(i, accumulator);
        }
        return result;
    }

    public MatrixIterator nonZeroIterator() {
        return this.nonZeroRowMajorIterator();
    }

    public RowMajorMatrixIterator nonZeroRowMajorIterator() {
        return new RowMajorMatrixIterator(this.rows, this.columns){
            private long limit;
            private long i;
            {
                this.limit = (long)this.rows * (long)this.columns;
                this.i = -1L;
            }

            @Override
            public int rowIndex() {
                return (int)(this.i / (long)this.columns);
            }

            @Override
            public int columnIndex() {
                return (int)(this.i - this.i / (long)this.columns * (long)this.columns);
            }

            @Override
            public double get() {
                return SparseMatrix.this.get(this.rowIndex(), this.columnIndex());
            }

            @Override
            public void set(double value) {
                SparseMatrix.this.set(this.rowIndex(), this.columnIndex(), value);
            }

            @Override
            public boolean hasNext() {
                while (this.i + 1L < this.limit) {
                    ++this.i;
                    if (!SparseMatrix.this.nonZeroAt(this.rowIndex(), this.columnIndex())) continue;
                    --this.i;
                    break;
                }
                return this.i + 1L < this.limit;
            }

            @Override
            public Double next() {
                ++this.i;
                return this.get();
            }
        };
    }

    public ColumnMajorMatrixIterator nonZeroColumnMajorIterator() {
        return new ColumnMajorMatrixIterator(this.rows, this.columns){
            private long limit;
            private long i;
            {
                this.limit = (long)this.rows * (long)this.columns;
                this.i = -1L;
            }

            @Override
            public int rowIndex() {
                return (int)(this.i - this.i / (long)this.rows * (long)this.rows);
            }

            @Override
            public int columnIndex() {
                return (int)(this.i / (long)this.rows);
            }

            @Override
            public double get() {
                return SparseMatrix.this.get(this.rowIndex(), this.columnIndex());
            }

            @Override
            public void set(double value) {
                SparseMatrix.this.set(this.rowIndex(), this.columnIndex(), value);
            }

            @Override
            public boolean hasNext() {
                while (this.i + 1L < this.limit) {
                    ++this.i;
                    if (!SparseMatrix.this.nonZeroAt(this.rowIndex(), this.columnIndex())) continue;
                    --this.i;
                    break;
                }
                return this.i + 1L < this.limit;
            }

            @Override
            public Double next() {
                ++this.i;
                return this.get();
            }
        };
    }

    public VectorIterator nonZeroIteratorOfRow(int i) {
        final int ii = i;
        return new VectorIterator(this.columns){
            private int j;
            {
                super(x0);
                this.j = -1;
            }

            @Override
            public int index() {
                return this.j;
            }

            @Override
            public double get() {
                return SparseMatrix.this.get(ii, this.j);
            }

            @Override
            public void set(double value) {
                SparseMatrix.this.set(ii, this.j, value);
            }

            @Override
            public boolean hasNext() {
                while (this.j + 1 < SparseMatrix.this.columns && SparseMatrix.this.isZeroAt(ii, this.j + 1)) {
                    ++this.j;
                }
                return this.j + 1 < SparseMatrix.this.columns;
            }

            @Override
            public Double next() {
                ++this.j;
                return this.get();
            }
        };
    }

    public VectorIterator nonZeroIteratorOfColumn(int j) {
        final int jj = j;
        return new VectorIterator(this.rows){
            private int i;
            {
                super(x0);
                this.i = -1;
            }

            @Override
            public int index() {
                return this.i;
            }

            @Override
            public double get() {
                return SparseMatrix.this.get(this.i, jj);
            }

            @Override
            public void set(double value) {
                SparseMatrix.this.set(this.i, jj, value);
            }

            @Override
            public boolean hasNext() {
                while (this.i + 1 < SparseMatrix.this.rows && SparseMatrix.this.isZeroAt(this.i + 1, jj)) {
                    ++this.i;
                }
                return this.i + 1 < SparseMatrix.this.rows;
            }

            @Override
            public Double next() {
                ++this.i;
                return this.get();
            }
        };
    }

    @Override
    public String toMatrixMarket(NumberFormat formatter) {
        String majority = this.isRowMajor() ? "row-major" : "column-major";
        StringBuilder out = new StringBuilder();
        MatrixIterator it = this.nonZeroIterator();
        out.append("%%MatrixMarket matrix coordinate real general ").append(majority).append('\n');
        out.append(this.rows).append(' ').append(this.columns).append(' ').append(this.cardinality).append('\n');
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            out.append(i + 1).append(' ').append(j + 1).append(' ').append(formatter.format(x)).append('\n');
        }
        return out.toString();
    }

    protected void ensureCardinalityIsCorrect(long rows, long columns, long cardinality) {
        long capacity;
        if (cardinality < 0L) {
            this.fail("Cardinality should be positive: " + cardinality + ".");
        }
        if (cardinality > (capacity = this.capacity())) {
            this.fail("Cardinality should be less then or equal to capacity: " + capacity + ".");
        }
    }
}

