/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.operation.ooplace;

import org.la4j.Matrix;
import org.la4j.iterator.ColumnMajorMatrixIterator;
import org.la4j.iterator.MatrixIterator;
import org.la4j.iterator.RowMajorMatrixIterator;
import org.la4j.matrix.ColumnMajorSparseMatrix;
import org.la4j.matrix.DenseMatrix;
import org.la4j.matrix.RowMajorSparseMatrix;
import org.la4j.matrix.SparseMatrix;
import org.la4j.operation.SimpleMatrixMatrixOperation;

public class OoPlaceMatricesSubtraction
extends SimpleMatrixMatrixOperation<Matrix> {
    @Override
    public Matrix apply(DenseMatrix a, DenseMatrix b) {
        Matrix result = a.blank();
        for (int i = 0; i < a.rows(); ++i) {
            for (int j = 0; j < a.columns(); ++j) {
                result.set(i, j, a.get(i, j) - b.get(i, j));
            }
        }
        return result;
    }

    @Override
    public Matrix applySimple(DenseMatrix a, SparseMatrix b) {
        Matrix result = a.copy();
        MatrixIterator it = b.nonZeroIterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            result.set(i, j, result.get(i, j) - x);
        }
        return result;
    }

    @Override
    public Matrix applySimple(SparseMatrix a, DenseMatrix b) {
        Matrix result = b.multiply(-1.0);
        MatrixIterator it = a.nonZeroIterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            result.set(i, j, result.get(i, j) + x);
        }
        return result;
    }

    @Override
    public Matrix applySimple(SparseMatrix a, SparseMatrix b) {
        Matrix result = a.blank();
        MatrixIterator these = a.nonZeroIterator();
        MatrixIterator those = b.nonZeroIterator();
        MatrixIterator both = these.orElseSubtract(those);
        while (both.hasNext()) {
            double x = (Double)both.next();
            int i = both.rowIndex();
            int j = both.columnIndex();
            result.set(i, j, x);
        }
        return result;
    }

    @Override
    public Matrix apply(RowMajorSparseMatrix a, ColumnMajorSparseMatrix b) {
        Matrix result = a.blank();
        RowMajorMatrixIterator these = a.nonZeroRowMajorIterator();
        RowMajorMatrixIterator those = b.nonZeroRowMajorIterator();
        MatrixIterator both = ((MatrixIterator)these).orElseSubtract(those);
        while (both.hasNext()) {
            double x = (Double)both.next();
            int i = both.rowIndex();
            int j = both.columnIndex();
            result.set(i, j, x);
        }
        return result;
    }

    @Override
    public Matrix apply(ColumnMajorSparseMatrix a, RowMajorSparseMatrix b) {
        Matrix result = a.blank();
        ColumnMajorMatrixIterator these = a.nonZeroColumnMajorIterator();
        ColumnMajorMatrixIterator those = b.nonZeroColumnMajorIterator();
        MatrixIterator both = ((MatrixIterator)these).orElseSubtract(those);
        while (both.hasNext()) {
            double x = (Double)both.next();
            int i = both.rowIndex();
            int j = both.columnIndex();
            result.set(i, j, x);
        }
        return result;
    }

    @Override
    public void ensureApplicableTo(Matrix a, Matrix b) {
        if (a.rows() != b.rows() || a.columns() != b.columns()) {
            throw new IllegalArgumentException("Given matrices should have the same shape: " + a.rows() + "x" + a.columns() + " does not equal to " + b.rows() + "x" + b.columns() + ".");
        }
    }
}

