/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.NonBlockingSupported;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.FilterUnacceptedException;
import org.mule.config.i18n.CoreMessages;
import org.mule.processor.AbstractInterceptingMessageProcessor;

public abstract class AbstractFilteringMessageProcessor
extends AbstractInterceptingMessageProcessor
implements NonBlockingSupported {
    protected boolean throwOnUnaccepted = false;
    protected boolean onUnacceptedFlowConstruct;
    protected MessageProcessor unacceptedMessageProcessor;

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        boolean accepted;
        try {
            accepted = this.accept(event);
        }
        catch (Exception ex) {
            throw this.filterFailureException(event, ex);
        }
        if (accepted) {
            return this.processNext(event);
        }
        return this.handleUnaccepted(event);
    }

    protected abstract boolean accept(MuleEvent var1);

    protected MuleEvent handleUnaccepted(MuleEvent event) throws MuleException {
        if (this.unacceptedMessageProcessor != null) {
            return this.unacceptedMessageProcessor.process(event);
        }
        if (this.throwOnUnaccepted) {
            throw this.filterUnacceptedException(event);
        }
        return null;
    }

    protected MessagingException filterFailureException(MuleEvent event, Exception ex) {
        return new MessagingException(event, ex, (MessageProcessor)this);
    }

    protected MuleException filterUnacceptedException(MuleEvent event) {
        return new FilterUnacceptedException(CoreMessages.messageRejectedByFilter(), event, (MessageProcessor)this);
    }

    public MessageProcessor getUnacceptedMessageProcessor() {
        return this.unacceptedMessageProcessor;
    }

    public void setUnacceptedMessageProcessor(MessageProcessor unacceptedMessageProcessor) {
        this.unacceptedMessageProcessor = unacceptedMessageProcessor;
        if (unacceptedMessageProcessor instanceof FlowConstruct) {
            this.onUnacceptedFlowConstruct = true;
        }
    }

    public boolean isThrowOnUnaccepted() {
        return this.throwOnUnaccepted;
    }

    public void setThrowOnUnaccepted(boolean throwOnUnaccepted) {
        this.throwOnUnaccepted = throwOnUnaccepted;
    }
}

