/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.List;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.AbstractRoutingStrategy;
import org.mule.routing.RoutingFailedMessagingException;
import org.mule.routing.filters.ExpressionFilter;

public class FirstSuccessfulRoutingStrategy
extends AbstractRoutingStrategy {
    protected ExpressionFilter failureExpressionFilter;
    private final MuleContext muleContext;
    private RouteProcessor processor;

    public FirstSuccessfulRoutingStrategy(MuleContext muleContext, String failureExpression, RouteProcessor processor) {
        super(muleContext);
        this.muleContext = muleContext;
        this.failureExpressionFilter = failureExpression != null ? new ExpressionFilter(failureExpression) : new ExpressionFilter("exception-type:");
        this.failureExpressionFilter.setMuleContext(muleContext);
        this.processor = processor;
    }

    @Override
    public MuleEvent route(MuleEvent event, List<MessageProcessor> messageProcessors) throws MessagingException {
        MuleEvent returnEvent = null;
        boolean failed = true;
        Exception failExceptionCause = null;
        for (MessageProcessor mp : messageProcessors) {
            try {
                MuleMessage msg;
                MuleEvent toProcess = this.cloneEventForRoutinng(event, mp);
                returnEvent = this.processor.processRoute(mp, toProcess);
                failed = returnEvent == null || VoidMuleEvent.getInstance().equals(returnEvent) ? false : (msg = returnEvent.getMessage()) == null || this.failureExpressionFilter.accept(msg);
            }
            catch (Exception ex) {
                failed = true;
                failExceptionCause = ex;
            }
            if (failed) continue;
            break;
        }
        if (failed) {
            if (failExceptionCause != null) {
                throw new RoutingFailedMessagingException(CoreMessages.createStaticMessage("all message processor failed during first successful routing strategy"), event, (Throwable)failExceptionCause);
            }
            throw new RoutingFailedMessagingException(CoreMessages.createStaticMessage("all message processor failed during first successful routing strategy"), event);
        }
        return returnEvent;
    }

    private MuleEvent cloneEventForRoutinng(MuleEvent event, MessageProcessor mp) throws MessagingException {
        return this.createEventToRoute(event, FirstSuccessfulRoutingStrategy.cloneMessage(event, event.getMessage(), this.muleContext), mp);
    }

    static interface RouteProcessor {
        public MuleEvent processRoute(MessageProcessor var1, MuleEvent var2) throws MessagingException, MuleException;
    }
}

